package com.bxm.game.scene.common.mango.entity;

import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 用户子账户<br/>
 *
 * @author kerry.jiang
 * @date 2022/4/12 15:56
 */
@Data
@Accessors(chain = true)
@Document(collection = "user_asset_sub")
public class UserAssetSub {

    /**
     * 主键（ObjectId，理论上不唯一）
     */
    @Id
    private String id;
    /**
     * 变现猫用户id
     * 具有唯一性
     */
    @Field("bxmuid")
    private String bxmuid;
    /**
     * 活动类型,如：G1006
     */
    @Field("activity_type")
    private String activityType;
    /**
     * 游戏代码
     */
    @Field("gcode")
    private String gcode;
    /**
     * 媒介代码
     */
    @Field("medium")
    private String medium;
    /**
     * 变现猫应用appid
     */
    @Field("appid")
    private String appid;
    /**
     * 全平台用户id
     */
    @Field("plfuid")
    private String plfuid;
    /**
     * 手机号
     */
    @Field("phone")
    private String phone;

    public final static String BXMUID = "bxmuid";
    public final static String ACTIVITY_TYPE = "activity_type";
    public final static String GCODE = "gcode";
    public final static String MEDIUM = "medium";
    public final static String APPID = "appid";
    public final static String PLFUID = "plfuid";
    public final static String PHONE = "phone";
}
