package com.bxm.foundation.config.advert.facade.service;

import com.bxm.foundation.config.advert.facade.param.AppAdvertEventReportParam;

/**
 * @author lowi
 * @date 2021/6/15 20:18
 */

public interface ThirdpartyAdvertCallbackService {

    /**
     * 用户激活时调用
     *
     * @param equipmentId 设备ID
     * @param userId      用户id
     * @param srcApp      服务来源
     */
    void active(String equipmentId, Long userId, String srcApp);


    /**
     * app看广告事件上报
     *
     * @param appAdvertEventReportParam 关系行为信息
     */
    void appAdvertEvent(AppAdvertEventReportParam appAdvertEventReportParam);


    /**
     * 用户登录时调用
     *
     * @param equipmentId 设备ID
     * @param userId      用户id
     * @param srcApp      服务来源
     */
    void login(String equipmentId, Long userId, String srcApp);


    /**
     * 获取设备子渠道
     *
     * @param equipmentId 设备ID
     * @param srcApp      服务来源
     */
    String getEquipmentSubChnl(String equipmentId, String srcApp);
}