package com.bxm.huola.message.common.bo;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * 消息发送者的相关信息，用于用户对用户触发的行为进行额外记录
 *
 * @author liujia
 * @date 2022/08/30 17:11:15
 * @since 1.3.0
 */
@Data
@Builder
public class PushMessageSender {
    @Tolerate
    public PushMessageSender() {
    }

    /**
     * 消息发送来源用户ID
     */
    private Long senderId;

    /**
     * 消息发送来源用户昵称
     */
    private String senderNickname;

    /**
     * 消息发送来源用户头像
     */
    private String senderHeadImg;
}
