package com.bxm.thirdparty.grant.facade.service;

import com.bxm.thirdparty.grant.facade.bo.WechatMpUserBO;

/**
 * 微信公众号对外接口
 *
 * @author liujia
 * @date 6/17/21 6:50 PM
 **/
public interface WechatMpFacadeService {

    /**
     * 通过微信的授权码获取公众号相关信息
     *
     * @param scene        业务场景值，需要与授权模块中配置的公众号的业务场景值保持一致
     * @param wxMpAuthCode 授权码
     * @return 授权码解析的用户信息对象（微信公众号的用户信息）
     */
    WechatMpUserBO exchangeWxMapUser(String scene, String wxMpAuthCode);

    /**
     * 获取业务场景值配置的appId
     *
     * @param accountId 账号ID
     * @return 公众号APPID
     */
    String obtainAppId(String accountId);
}
