package com.bxm.thirdparty.grant.facade.bo;

import lombok.Data;

import java.io.Serializable;

/**
 * @author liujia
 * @date 6/17/21 6:54 PM
 **/
@Data
public class WechatMpUserBO implements Serializable {

    /**
     * 微信公众号的用户的oid
     */
    private String openId;

    /**
     * https://mp.weixin.qq.com/cgi-bin/announce?action=getannouncement&announce_id=11513156443eZYea&version=&lang=zh_CN
     * <pre>
     * 只有在将公众号绑定到微信开放平台帐号后，才会出现该字段。
     * 另外，在用户未关注公众号时，将不返回用户unionID信息。
     * 已关注的用户，开发者可使用“获取用户基本信息接口”获取unionID；
     * 未关注用户，开发者可使用“微信授权登录接口”并将scope参数设置为snsapi_userinfo，获取用户unionID
     * </pre>
     */
    private String unionId;

    /**
     * nickname	普通用户昵称
     */
    private String nickname;
    /**
     * sex	普通用户性别，1为男性，2为女性
     */
    private Integer sex;
    /**
     * city	普通用户个人资料填写的城市
     */
    private String city;

    /**
     * province	普通用户个人资料填写的省份
     */
    private String province;
    /**
     * country	国家，如中国为CN
     */
    private String country;
    /**
     * headimgurl	用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像），
     * 用户没有头像时该项为空
     */
    private String headImgUrl;
}
