/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.api.controller;

import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.ResponseJson;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.facade.request.ChargePhoneRequest;
import com.bxm.thirdparty.platform.facade.request.ElectricRequest;
import com.bxm.thirdparty.platform.facade.request.PaymentPreRequest;
import com.bxm.thirdparty.platform.facade.request.PaymentRefundRequest;
import com.bxm.thirdparty.platform.facade.request.WithdrawRequest;
import com.bxm.thirdparty.platform.facade.response.ChargePhoneTopUpResponse;
import com.bxm.thirdparty.platform.facade.response.ElectricTopUpResponse;
import com.bxm.thirdparty.platform.facade.response.PrePaymentResponse;
import com.bxm.thirdparty.platform.facade.response.RefundResponse;
import com.bxm.thirdparty.platform.facade.response.WithdrawResponse;
import com.bxm.thirdparty.platform.service.ThirdPartyPlatformService;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"{version}/3rd/platform"})
@RestController
public class ThirdPartyPlatformController {
    private static final Logger log = LoggerFactory.getLogger(ThirdPartyPlatformController.class);
    @Resource
    private ThirdPartyPlatformService thirdPartyPlatformService;

    @ApiOperation(value="3-02-3 [v1]\u53d1\u8d77\u9884\u652f\u4ed8")
    @PostMapping(value={"payment/pre"})
    @ApiVersion(value=1)
    public ResponseJson<PrePaymentResponse> prePayment(@Valid @RequestBody PaymentPreRequest param, HttpServletRequest request) {
        log.info("\u4e1a\u52a1\u65b9\u53d1\u8d77\u9884\u652f\u4ed8\uff1a{}", (Object)param);
        param.setRequestIp(WebUtils.getIpAddr((HttpServletRequest)request));
        Message message = this.thirdPartyPlatformService.execPlatformHandler((BaseRequest)param);
        if (message.isSuccess()) {
            PrePaymentResponse response = (PrePaymentResponse)message.getParam(CommonConstant.RESULT_DTO);
            return ResponseJson.ok((Object)response);
        }
        return ResponseJson.build((Message)message);
    }

    @ApiOperation(value="3-02-3 [v1]\u53d1\u8d77\u8bdd\u8d39\u5145\u503c")
    @PostMapping(value={"phone/topUp"})
    @ApiVersion(value=1)
    public ResponseJson<ChargePhoneTopUpResponse> chargePhoneTopUp(@Valid @RequestBody ChargePhoneRequest param, HttpServletRequest request) {
        log.info("\u4e1a\u52a1\u65b9\u53d1\u8d77\u8bdd\u8d39\u5145\u503c\uff1a{}", (Object)param);
        Message message = this.thirdPartyPlatformService.execPlatformHandler((BaseRequest)param);
        if (message.isSuccess()) {
            ChargePhoneTopUpResponse response = (ChargePhoneTopUpResponse)message.getParam(CommonConstant.RESULT_DTO);
            return ResponseJson.ok((Object)response);
        }
        return ResponseJson.build((Message)message);
    }

    @ApiOperation(value="3-02-3 [v1]\u53d1\u8d77\u7535\u8d39\u5145\u503c")
    @PostMapping(value={"electric/topUp"})
    @ApiVersion(value=1)
    public ResponseJson<ElectricTopUpResponse> electricTopUp(@Valid @RequestBody ElectricRequest param, HttpServletRequest request) {
        log.info("\u4e1a\u52a1\u65b9\u53d1\u8d77\u7535\u8d39\u5145\u503c\uff1a{}", (Object)param);
        Message message = this.thirdPartyPlatformService.execPlatformHandler((BaseRequest)param);
        if (message.isSuccess()) {
            ElectricTopUpResponse response = (ElectricTopUpResponse)message.getParam(CommonConstant.RESULT_DTO);
            return ResponseJson.ok((Object)response);
        }
        return ResponseJson.build((Message)message);
    }

    @ApiOperation(value="3-02-3 [v1]\u53d1\u8d77\u9000\u6b3e")
    @PostMapping(value={"payment/refund"})
    @ApiVersion(value=1)
    public ResponseJson<RefundResponse> prePayment(@Valid @RequestBody PaymentRefundRequest param, HttpServletRequest request) {
        log.info("\u4e1a\u52a1\u65b9\u53d1\u8d77\u9000\u6b3e\uff1a{}", (Object)param);
        param.setRequestIp(WebUtils.getIpAddr((HttpServletRequest)request));
        Message message = this.thirdPartyPlatformService.execPlatformHandler((BaseRequest)param);
        if (message.isSuccess()) {
            RefundResponse response = (RefundResponse)message.getParam(CommonConstant.RESULT_DTO);
            return ResponseJson.ok((Object)response);
        }
        return ResponseJson.build((Message)message);
    }

    @ApiOperation(value="3-02-3 [v1]\u53d1\u8d77\u63d0\u73b0")
    @PostMapping(value={"payment/withdraw"})
    @ApiVersion(value=1)
    public ResponseJson<WithdrawResponse> prePayment(@Valid @RequestBody WithdrawRequest param, HttpServletRequest request) {
        log.info("\u4e1a\u52a1\u65b9\u53d1\u8d77\u63d0\u73b0\uff1a{}", (Object)param);
        param.setRequestIp(WebUtils.getIpAddr((HttpServletRequest)request));
        Message message = this.thirdPartyPlatformService.execPlatformHandler((BaseRequest)param);
        if (message.isSuccess()) {
            WithdrawResponse response = (WithdrawResponse)message.getParam(CommonConstant.RESULT_DTO);
            return ResponseJson.ok((Object)response);
        }
        return ResponseJson.build((Message)message);
    }
}

