/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.facade.enums;

import com.bxm.thirdparty.platform.facade.notify.ChargePhoneNotifyResponse;
import com.bxm.thirdparty.platform.facade.notify.ElectricNotifyResponse;
import com.bxm.thirdparty.platform.facade.notify.PaymentNotifyResponse;
import com.bxm.thirdparty.platform.facade.notify.RefundNotifyResponse;
import com.bxm.thirdparty.platform.facade.notify.WithdrawNotifyResponse;
import com.bxm.thirdparty.platform.facade.request.ChargePhoneRequest;
import com.bxm.thirdparty.platform.facade.request.ElectricRequest;
import com.bxm.thirdparty.platform.facade.request.PaymentPreRequest;
import com.bxm.thirdparty.platform.facade.request.PaymentRefundRequest;
import com.bxm.thirdparty.platform.facade.request.WithdrawRequest;
import com.bxm.thirdparty.platform.facade.response.ChargePhoneTopUpResponse;
import com.bxm.thirdparty.platform.facade.response.ElectricTopUpResponse;
import com.bxm.thirdparty.platform.facade.response.PrePaymentResponse;
import com.bxm.thirdparty.platform.facade.response.RefundResponse;
import com.bxm.thirdparty.platform.facade.response.WithdrawResponse;
import java.util.Objects;

public enum NotifyTypeEnum {
    PAYMENT(PaymentPreRequest.class, PrePaymentResponse.class, PaymentNotifyResponse.class),
    WITHDRAW(WithdrawRequest.class, WithdrawResponse.class, WithdrawNotifyResponse.class),
    REFUND(PaymentRefundRequest.class, RefundResponse.class, RefundNotifyResponse.class),
    CHARGE_PHONE(ChargePhoneRequest.class, ChargePhoneTopUpResponse.class, ChargePhoneNotifyResponse.class),
    ELECTRIC(ElectricRequest.class, ElectricTopUpResponse.class, ElectricNotifyResponse.class);

    private Class<?> requestClass;
    private Class<?> responseClass;
    private Class<?> notifyClass;

    private NotifyTypeEnum(Class<?> requestClass, Class<?> responseClass, Class<?> notifyClass) {
        this.requestClass = requestClass;
        this.responseClass = responseClass;
        this.notifyClass = notifyClass;
    }

    public static NotifyTypeEnum getRequestType(String classSimpleName) {
        for (NotifyTypeEnum value : NotifyTypeEnum.values()) {
            if (!Objects.equals(classSimpleName, value.getRequestClass().getSimpleName())) continue;
            return value;
        }
        return null;
    }

    public static NotifyTypeEnum getByType(String type) {
        for (NotifyTypeEnum value : NotifyTypeEnum.values()) {
            if (!Objects.equals(type, value.name())) continue;
            return value;
        }
        return null;
    }

    public Class<?> getRequestClass() {
        return this.requestClass;
    }

    public Class<?> getResponseClass() {
        return this.responseClass;
    }

    public Class<?> getNotifyClass() {
        return this.notifyClass;
    }
}

