/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.facade.register;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.bxm.thirdparty.platform.facade.service.RegisterNotifyService;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RegisterRunner
implements ApplicationRunner,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(RegisterRunner.class);
    private ApplicationContext applicationContext;
    private final String TEST_REGISTER_URL = "https://test.91huola.com:16001/v1/3rd/register/notify";
    private final String LOCAL_REGISTER_URL = "http://dev.91huola.com:16001/v1/3rd/register/notify";
    private final String PRO_REGISTER_URL = "https://api-3rd.91huola.com/v1/3rd/register/notify";

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void run(ApplicationArguments args) throws Exception {
        Map beansOfType = this.applicationContext.getBeansOfType(RegisterNotifyService.class);
        if (beansOfType.size() == 0) {
            log.error("\u5185\u90e8\u670d\u52a1\u6ce8\u518c\u5931\u8d25\uff0c\u8bf7\u5b9e\u73b0RegisterService\u63a5\u53e3");
            return;
        }
        if (beansOfType.size() > 1) {
            log.error("\u5185\u90e8\u670d\u52a1\u6ce8\u518c\u5931\u8d25\uff0c\u4fdd\u8bc1\u5b9e\u73b0RegisterService\u63a5\u53e3\u7c7b <=1 \u4e2a");
            return;
        }
        RegisterNotifyService bean = (RegisterNotifyService)this.applicationContext.getBean(RegisterNotifyService.class);
        String application = bean.application();
        String notifyUrl = bean.notifyUrl();
        if (StringUtils.isEmpty((Object)application) || StringUtils.isEmpty((Object)notifyUrl)) {
            log.error("\u5185\u90e8\u670d\u52a1\u6ce8\u518c\u5931\u8d25\uff0c\u8bf7\u914d\u7f6eapplicationName\u548c\u901a\u77e5\u5730\u5740");
            return;
        }
        Environment environment = this.applicationContext.getEnvironment();
        String[] activeProfiles = environment.getActiveProfiles();
        String registerUrl = Objects.equals(activeProfiles[0], "PRO") ? "https://api-3rd.91huola.com/v1/3rd/register/notify" : (Objects.equals(activeProfiles[0], "FAT") ? "https://test.91huola.com:16001/v1/3rd/register/notify" : "http://dev.91huola.com:16001/v1/3rd/register/notify");
        HttpRequest httpRequest = HttpUtil.createPost((String)registerUrl);
        httpRequest.contentType("application/json");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("applicationName", application);
        map.put("notifyUrl", notifyUrl);
        StringBuilder jsonStr = new StringBuilder();
        StringBuilder append = jsonStr.append("{").append("\"").append("applicationName").append("\":").append("\"").append(application).append("\",").append("\"").append("notifyUrl").append("\":").append("\"").append(notifyUrl).append("\"}");
        httpRequest.body(append.toString());
        try {
            HttpResponse execute = httpRequest.execute();
            if (execute.isOk()) {
                log.info("\u5185\u90e8\u670d\u52a1\u6ce8\u518c\u6210\u529fapplication\uff1a{},notifyUrl :{},body:{}", new Object[]{application, notifyUrl, execute.body()});
            }
        }
        catch (Exception e) {
            log.error("\u5185\u90e8\u670d\u52a1\u6ce8\u518c\u5931\u8d25:", (Throwable)e);
        }
    }
}

