package com.bxm.thirdparty.platform.adapter.chargephone;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.AbstractThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.facade.notify.ChargePhoneNotifyResponse;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.facade.request.ChargePhoneRequest;
import com.bxm.thirdparty.platform.facade.response.ChargePhoneTopUpResponse;
import com.bxm.thirdparty.platform.model.entity.ChargesPhoneLogEntity;
import org.checkerframework.checker.units.qual.C;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/4/4 17:13
 */
@Component
public class ChargePhonePlatformAction extends AbstractThirdPartyPlatformAction<ChargePhoneRequest, ChargesPhoneLogEntity> {

    @Resource
    private IChargePhoneActionDispatcher<ChargePhoneRequest, ChargesPhoneLogEntity> iChargePhoneActionDispatcher;


    @Override
    protected Message exec(PlatformContext context) {
        Message exec = iChargePhoneActionDispatcher.exec(context);
        //因为第三方服务500的问题，丢入队列
        if (!exec.isSuccess() && Objects.equals(exec.getBizCode(), CommonConstant.THIRD_PARTY_500)) {
            //todo 丢入失败队列
        }
        return exec;
    }

    @Override
    protected Message mockResult(PlatformContext<ChargePhoneRequest, ChargesPhoneLogEntity> context) {
        ChargePhoneRequest request = context.getRequest();
        ChargesPhoneLogEntity orderNo = context.getOrderInfo();

        ChargePhoneTopUpResponse response = new ChargePhoneTopUpResponse();
        response.setRequestId(context.getRequestId());
        response.setMoney(request.getMoney());
        response.setPhoneNo(request.getPhoneNo());
        response.setOutOrderNo(orderNo.getOutOrderNo());
        response.setOrderNo(orderNo.getOrderNo().toString());


        ChargePhoneNotifyResponse notifyResponse = new ChargePhoneNotifyResponse();
        notifyResponse.setSuccess(true);
        notifyResponse.setOrderNo(orderNo.getOrderNo().toString());
        notifyResponse.setOutOrderNo(orderNo.getOutOrderNo());
        submitQueueNotify(context, JSON.toJSONString(notifyResponse));

        return Message.build().addParam(CommonConstant.RESULT_DTO, response);
    }

    @Override
    public Class<? extends BaseRequest> support() {
        return ChargePhoneRequest.class;
    }
}
