package com.bxm.thirdparty.platform.adapter.chargephone.xinrong.enums;

import lombok.Getter;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/3/27 19:38
 */
@Getter
public enum XinRongChargeCouponEnum {

    /**
     * 心融产品类型（慢充）对应字典
     */
    MC_M_HFZC_5("移动", BigDecimal.valueOf(5)),

    MC_M_HFZC_10("移动", BigDecimal.valueOf(10)),

    MC_M_HFZC_20("移动", BigDecimal.valueOf(20)),

    MC_M_HFZC_30("移动", BigDecimal.valueOf(30)),

    MC_M_HFZC_50("移动", BigDecimal.valueOf(50)),

    MC_M_HFZC_100("移动", BigDecimal.valueOf(100)),

    MC_M_HFZC_200("移动", BigDecimal.valueOf(200)),

    MC_M_HFZC_300("移动", BigDecimal.valueOf(300)),

    MC_M_HFZC_400("移动", BigDecimal.valueOf(400)),

    MC_M_HFZC_500("移动", BigDecimal.valueOf(500)),

    MC_U_HFZC_5("联通", BigDecimal.valueOf(5)),

    MC_U_HFZC_10("联通", BigDecimal.valueOf(10)),

    MC_U_HFZC_20("联通", BigDecimal.valueOf(20)),

    MC_U_HFZC_30("联通", BigDecimal.valueOf(30)),

    MC_U_HFZC_50("联通", BigDecimal.valueOf(50)),

    MC_U_HFZC_100("联通", BigDecimal.valueOf(100)),

    MC_U_HFZC_200("联通", BigDecimal.valueOf(200)),

    MC_U_HFZC_300("联通", BigDecimal.valueOf(300)),

    MC_U_HFZC_500("联通", BigDecimal.valueOf(500)),


    MC_T_HFZC_5("电信", BigDecimal.valueOf(5)),

    MC_T_HFZC_10("电信", BigDecimal.valueOf(10)),

    MC_T_HFZC_20("电信", BigDecimal.valueOf(20)),

    MC_T_HFZC_30("电信", BigDecimal.valueOf(30)),

    MC_T_HFZC_50("电信", BigDecimal.valueOf(50)),

    MC_T_HFZC_100("电信", BigDecimal.valueOf(100)),

    MC_T_HFZC_200("电信", BigDecimal.valueOf(200)),

    MC_T_HFZC_300("电信", BigDecimal.valueOf(300)),

    MC_T_HFZC_500("电信", BigDecimal.valueOf(500)),
    ;

    private String carrier;

    private BigDecimal amount;

    XinRongChargeCouponEnum(String carrier, BigDecimal amount) {
        this.carrier = carrier;
        this.amount = amount;
    }

    public static XinRongChargeCouponEnum get(String carrier, BigDecimal amount) {
        for (XinRongChargeCouponEnum value : values()) {
            if (Objects.equals(carrier, value.getCarrier()) && amount.compareTo(value.getAmount()) == 0) {
                return value;
            }
        }
        return null;
    }
}
