package com.bxm.thirdparty.platform.adapter.chargephone.xinrong.utils;

import cn.hutool.http.HttpUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.thirdparty.platform.adapter.chargephone.xinrong.bo.CheckAccountBO;
import com.bxm.thirdparty.platform.adapter.chargephone.xinrong.bo.XinRongChargeBO;
import com.bxm.thirdparty.platform.adapter.chargephone.xinrong.bo.XinRongOrderInfoBO;
import com.bxm.thirdparty.platform.adapter.chargephone.xinrong.enums.XinRongChargeCouponEnum;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.facade.request.ChargePhoneRequest;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author lowi
 * @date 2023/3/27 20:35
 */
@Slf4j
public class XinRongUtil {

    public final static Integer SUCCESS_CODE = 200;

    private ThirdPartyConfigProperties thirdPartyConfigProperties;

    public XinRongUtil(ThirdPartyConfigProperties thirdPartyConfigProperties) {
        this.thirdPartyConfigProperties = thirdPartyConfigProperties;
    }


    public String topUp(ChargePhoneRequest request, String outLogNo, XinRongChargeCouponEnum chargeCouponEnum) {
        Map<String, String> paramsMap = Maps.newHashMap();
        paramsMap.put("account", request.getPhoneNo());
        paramsMap.put("out_logno", outLogNo);
        paramsMap.put("productsn", chargeCouponEnum.name());
        paramsMap.put("money", chargeCouponEnum.getAmount().toString());
        Map<String, Object> requestParamMap = getParamMap(paramsMap, "create");
        String response = null;
        try {
            response = HttpUtil.get(thirdPartyConfigProperties.getXinRongCreateOrder(), requestParamMap);
        } catch (Exception e) {
            log.info("调取第三方话费充值失败：param:{},exception:{}", JSON.toJSONString(requestParamMap), e);
            return null;
        }
        return response;
    }


    public BigDecimal getAccountBalance() {
        Map<String, String> paramsMap = Maps.newHashMap();
        paramsMap.put("query_type", "1");

        Map<String, Object> requestParamMap = getParamMap(paramsMap, "checkaccount");
        String resultDto = null;
        try {
            resultDto = HttpUtil.get(thirdPartyConfigProperties.getXinRongCheckAccount(), requestParamMap);
        } catch (Exception e) {
            log.info("调取第三方话费余额查询失败：param:{},exception:{}", JSON.toJSONString(requestParamMap), e);
            return BigDecimal.ZERO;
        }

        log.info("调取第三方话费余额查询：param:{},result:{}", JSON.toJSONString(requestParamMap), resultDto);
        XinRongChargeBO xinRongChargeBO = JSON.parseObject(resultDto, XinRongChargeBO.class);

        if (Objects.nonNull(xinRongChargeBO) && Objects.equals(SUCCESS_CODE, xinRongChargeBO.getCode())) {
            CheckAccountBO checkAccountBO = JSON.parseObject(JSON.toJSONString(xinRongChargeBO.getData()), CheckAccountBO.class);
            return checkAccountBO.getBalance();
        }
        log.error("调取第三方话费查询余额失败param:{},：{}", requestParamMap, resultDto);
        return BigDecimal.ZERO;
    }

    public BigDecimal getSellMoney(String orderNo, String thirdPartyOrderNo) {
        Map<String, String> paramsMap = Maps.newHashMap();
        paramsMap.put("out_logno", orderNo);
        paramsMap.put("logno", thirdPartyOrderNo);

        Map<String, Object> requestParamMap = getParamMap(paramsMap, "query");

        String resultDto = null;
        try {
            resultDto = HttpUtil.get(thirdPartyConfigProperties.getXinRongCheckAccount(), requestParamMap);
        } catch (Exception e) {
            log.info("调取第三方话费余额查询失败：param:{},exception:{}", JSON.toJSONString(requestParamMap), e);
            return BigDecimal.ZERO;
        }

        log.info("调取第三方话费余额查询：param:{},result:{}", JSON.toJSONString(requestParamMap), resultDto);
        XinRongChargeBO xinRongChargeBO = JSON.parseObject(resultDto, XinRongChargeBO.class);

        if (Objects.nonNull(xinRongChargeBO) && Objects.equals(SUCCESS_CODE, xinRongChargeBO.getCode())) {
            XinRongOrderInfoBO orderInfoBO = JSON.parseObject(JSON.toJSONString(xinRongChargeBO.getData()), XinRongOrderInfoBO.class);
            return orderInfoBO.getSellMoney();
        }
        log.error("调取第三方话费查询余额失败param:{},：{}", requestParamMap, resultDto);
        return BigDecimal.ZERO;
    }


    private Map<String, Object> getParamMap(Map<String, String> paramMap, String type) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("client_id", thirdPartyConfigProperties.getXinRongClientId());
        params.put("type", type);
        params.put("data_type", "JSON");
        params.put("body", JSON.toJSONString(paramMap));
        params.put("sign", getSign(paramMap));
        return params;
    }

    private String getSign(Map<String, String> params) {
        Set<String> keyList = params.keySet();
        List<String> list = new ArrayList<>(keyList);
        Collections.sort(list);

        StringBuilder sb = new StringBuilder();
        sb.append(thirdPartyConfigProperties.getXinRongClientSecret());
        for (String key : list) {
            sb.append(key).append(params.get(key));
        }
        sb.append(thirdPartyConfigProperties.getXinRongClientSecret());
        return MD5Util.standardMd5(sb.toString()).toUpperCase();
    }
}
