package com.bxm.thirdparty.platform.adapter.electric;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.AbstractThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.facade.notify.ChargePhoneNotifyResponse;
import com.bxm.thirdparty.platform.facade.notify.ElectricNotifyResponse;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.facade.request.ElectricRequest;
import com.bxm.thirdparty.platform.facade.response.ElectricTopUpResponse;
import com.bxm.thirdparty.platform.model.entity.ElectricLogEntity;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author lowi
 * @date 2023/4/4 17:13
 */
@Component
public class ElectricPlatformAction extends AbstractThirdPartyPlatformAction<ElectricRequest, ElectricLogEntity> {

    @Resource
    private IElectricActionDispatcher<ElectricRequest,ElectricLogEntity> iChargePhoneActionDispatcher;


    @Override
    public Message exec(PlatformContext<ElectricRequest, ElectricLogEntity> context) {
        Message exec = iChargePhoneActionDispatcher.exec(context);
        if (!exec.isSuccess()) {
            //todo 丢入失败队列
        }
        return exec;
    }


    @Override
    public Class<? extends BaseRequest> support() {
        return ElectricRequest.class;
    }

    @Override
    protected Message mockResult(PlatformContext<ElectricRequest, ElectricLogEntity> context) {
        ElectricRequest request = context.getRequest();
        ElectricLogEntity orderInfo = context.getOrderInfo();

        ElectricTopUpResponse response = new ElectricTopUpResponse();
        response.setSuccess(true);
        response.setRequestId(context.getRequestId());
        response.setAccount(request.getAccount());
        response.setAmount(request.getAmount());
        response.setOutOrderNo(orderInfo.getOutOrderNo());
        response.setOrderNo(orderInfo.getOrderNo().toString());

        ElectricNotifyResponse notifyResponse = new ElectricNotifyResponse();
        notifyResponse.setSuccess(true);
        notifyResponse.setOrderNo(orderInfo.getOrderNo().toString());
        notifyResponse.setOutOrderNo(orderInfo.getOutOrderNo());
        submitQueueNotify(context, JSON.toJSONString(notifyResponse));

        return Message.build().addParam(CommonConstant.RESULT_DTO, response);
    }
}
