package com.bxm.thirdparty.platform.adapter.electric.liba.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpStatus;
import cn.hutool.http.HttpUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.thirdparty.platform.adapter.electric.liba.bo.LiBaBO;
import com.bxm.thirdparty.platform.adapter.electric.liba.bo.LiBaCheckAccountBO;
import com.bxm.thirdparty.platform.adapter.electric.liba.bo.LiBaCreateOrderResultBO;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author lowi
 * @date 2023/3/30 19:24
 */
@Slf4j
public class LiBaUtil {

    private ThirdPartyConfigProperties thirdPartyConfigProperties;

    public LiBaUtil(ThirdPartyConfigProperties thirdPartyConfigProperties) {
        this.thirdPartyConfigProperties = thirdPartyConfigProperties;
    }

    public String createOrder(Map<String, Object> paramMap) {
        paramMap.put("appId", thirdPartyConfigProperties.getLiBaAppId());
        paramMap.put("timestamp", DateUtil.current());
        paramMap.put("sign", getSign(paramMap));
        HttpRequest httpRequest = HttpUtil.createPost(thirdPartyConfigProperties.getLiBaCreateOrderApi());
        httpRequest.contentType("multipart/form-data");

        httpRequest.form(paramMap);

        HttpResponse execute = null;
        try {
            execute = httpRequest.execute();
            log.info("请求力拔电费充值，请求体：{}，返回体：{}", paramMap, execute.body());
            return execute.body();
        } catch (Exception e) {
            log.error("liba话费充值失败，请求力拔接口报错：{}", paramMap, e);
        }
        return null;
    }

    public BigDecimal checkAccount() {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("appId", thirdPartyConfigProperties.getLiBaAppId());
        paramMap.put("timestamp", DateUtil.current());
        paramMap.put("sign", getSign(paramMap));
        HttpRequest httpRequest = HttpUtil.createPost(thirdPartyConfigProperties.getLiBaCheckAccountApi());
        httpRequest.contentType("multipart/form-data");
        httpRequest.form(paramMap);
        HttpResponse execute = null;
        try {
            execute = httpRequest.execute();
            log.info("请求力拔电费充值账户余额，请求体：{}，返回体：{}", paramMap, execute.body());
            if (execute.isOk()) {
                String body = execute.body();
                LiBaBO liBaBO = JSON.parseObject(body, LiBaBO.class);
                if (Objects.nonNull(liBaBO) && Objects.equals(liBaBO.getReturnCode(), HttpStatus.HTTP_OK)) {
                    LiBaCheckAccountBO liBaCheckAccountBO = JSON.parseObject(JSON.toJSONString(liBaBO.getData()), LiBaCheckAccountBO.class);
                    return liBaCheckAccountBO.getAmountBalance();
                }
            }
            return BigDecimal.ZERO;

        } catch (Exception e) {
            log.error("调用liba第三方服务失败paramMap:{},e:{}", paramMap, e.getMessage());
            return BigDecimal.ZERO;
        }
    }

    private String getSign(Map<String, Object> params) {
        Set<String> keyList = params.keySet();
        List<String> list = new ArrayList<>(keyList);
        Collections.sort(list);

        StringBuilder sb = new StringBuilder();
        for (String key : list) {
            sb.append(key).append(params.get(key)).append("&");
        }
        sb.append(thirdPartyConfigProperties.getLiBaAppKey());
        return MD5Util.standardMd5(sb.toString()).toUpperCase();
    }
}
