package com.bxm.thirdparty.platform.adapter.payment;


import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentModeEnum;
import com.bxm.thirdparty.platform.adapter.payment.request.PaymentRequest;
import com.bxm.thirdparty.platform.enums.PlatformEnum;

/**
 * @author lowi
 * @date 2023/4/3 18:09
 */
public abstract class PayPlatformAction<R extends PaymentRequest> {

    /**
     * 执行具体的支付动作
     *
     * @param request 请求参数
     * @return 响应结果
     */
    protected abstract Message exec(R request);


    /**
     * 当前业务匹配的支付模式（同一种支付模式，同一种支付动作，会存在不同的支付模式区别）
     *
     * @return 当前实例支持的支付模式
     */
    protected PaymentModeEnum matchMode() {
        return PaymentModeEnum.COMMON;
    }

    /**
     * 当前业务支持的支付动作，对应支付流程中的不同环节
     *
     * @return 当前实例支持的支付动作
     */
    protected abstract PaymentActionEnum matchAction();

    /**
     * 平台枚举
     *
     * @return {@link PlatformEnum}
     */
    protected abstract PlatformEnum platform();
}
