package com.bxm.thirdparty.platform.adapter.payment.enums;

/**
 * 支付模式枚举定义
 *
 * @author liujia
 * @date 2020/5/29 11:07
 **/
public enum PaymentModeEnum {
    /**
     * 通过H5支付，APP内的WEBVIEW支付页可以使用此方式
     */
    H5,

    /**
     * 通过调用支付客户端提供的JS-SDK提供支付功能
     */
    JSAPI,

    /**
     * 调用内嵌的支付SDK发起支付
     */
    APP,

    /**
     * 小程序内的支付
     */
    APPLET,

    /**
     * 所有支付模式通用
     */
    COMMON;


    public static PaymentModeEnum get(String mode){
        for (PaymentModeEnum value : values()) {
            if(value.name().equals(mode)){
                return value;
            }
        }
        return null;
    }
}
