package com.bxm.thirdparty.platform.adapter.payment.pay.ali;

import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayResponse;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.payment.facade.PaymentConfigFacadeService;
import com.bxm.thirdparty.platform.adapter.payment.PayPlatformAction;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentModeEnum;
import com.bxm.thirdparty.platform.adapter.payment.pay.ali.request.AliH5PrePaymentRequest;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.response.PrePaymentResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/3/27 10:06
 */
@Component
@Slf4j
public class AliH5PreOrderAction extends PayPlatformAction<AliH5PrePaymentRequest> {

    @Resource
    private PaymentConfigFacadeService paymentConfigFacadeService;

    @Resource
    private ThirdPartyConfigProperties configProperties;

    @Override
    protected Message exec(AliH5PrePaymentRequest request) {

        AlipayClient alipayClient = paymentConfigFacadeService.getAliClientByMchId(request.getAccountId());
        if (Objects.isNull(alipayClient)) {
            return Message.build(false).setMessage("支付账户不存在");
        }

        PrePaymentResponse prePaymentResponse = new PrePaymentResponse();

        if (request.getMock()) {
            return Message.build().addParam(CommonConstant.RESULT_DTO, prePaymentResponse);
        }

        AlipayTradeWapPayRequest alipayRequest = new AlipayTradeWapPayRequest();
        alipayRequest.setBizModel(createWapPayModel(request, request.getRequestOrderNo()));
        alipayRequest.setNotifyUrl(configProperties.getServerUrl() + configProperties.getAliPayCallbackUrl());

        AlipayResponse execute = null;
        try {
            execute = alipayClient.pageExecute(alipayRequest);
            prePaymentResponse.setLink(execute.getBody());
        } catch (Exception e) {
            log.error("调用支付宝预支付失败，param:{},exception：", request, e);
            return Message.build(false).setMessage("调用支付宝预支付失败" + e.getMessage());
        }
        return Message.build().addParam(CommonConstant.RESULT_DTO, prePaymentResponse);
    }

    private AlipayTradeWapPayModel createWapPayModel(AliH5PrePaymentRequest request, String trackNo) {
        // 只保留两位小数
        BigDecimal amount = request.getAmount().setScale(2, RoundingMode.DOWN);
        AlipayTradeWapPayModel model = new AlipayTradeWapPayModel();
        model.setOutTradeNo(trackNo);
        model.setTotalAmount(amount.toString());
        model.setSubject(request.getTitle());
        model.setProductCode("QUICK_WAP_WAY");
        model.setQuitUrl(request.getQuitUrl());
        model.setBody(request.getOrderDescription());
        model.setTimeoutExpress("30m");
        return model;
    }

    @Override
    protected PaymentModeEnum matchMode() {
        return PaymentModeEnum.H5;
    }

    @Override
    protected PaymentActionEnum matchAction() {
        return PaymentActionEnum.PRE_PAYMENT;
    }

    @Override
    protected PlatformEnum platform() {
        return PlatformEnum.ALI;
    }
}
