package com.bxm.thirdparty.platform.adapter.payment.pay.wx;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.payment.facade.PaymentConfigFacadeService;
import com.bxm.thirdparty.platform.adapter.payment.PayPlatformAction;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentModeEnum;
import com.bxm.thirdparty.platform.adapter.payment.pay.wx.request.WxAppletPrePayRequest;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.response.PrePaymentResponse;
import com.bxm.thirdparty.platform.facade.response.WxAppletResponse;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.constant.WxPayConstants;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/3/27 10:06
 */
@Component
@Slf4j
public class WxAppletPreOrderAction extends PayPlatformAction<WxAppletPrePayRequest> {

    @Resource
    private PaymentConfigFacadeService paymentConfigFacadeService;

    @Resource
    private ThirdPartyConfigProperties partyConfigProperties;

    @Override
    public Message exec(WxAppletPrePayRequest request) {
        WxPayService wxPayService = paymentConfigFacadeService.getWxClientByMchId(request.getAccountId());

        if (Objects.isNull(wxPayService)) {
            return Message.build(false).setMessage("支付账户不存在");

        }
        PrePaymentResponse prePaymentResponse = new PrePaymentResponse();

        if (request.getMock()) {

            return Message.build().addParam(CommonConstant.RESULT_DTO, prePaymentResponse);
        }

        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = new WxPayUnifiedOrderRequest();
        wxPayUnifiedOrderRequest.setAppid(request.getAppId());
        wxPayUnifiedOrderRequest.setTradeType(WxPayConstants.TradeType.JSAPI);
        wxPayUnifiedOrderRequest.setDeviceInfo("WEB");
        wxPayUnifiedOrderRequest.setOutTradeNo(request.getRequestOrderNo());
        wxPayUnifiedOrderRequest.setBody(request.getOrderDescription());
        wxPayUnifiedOrderRequest.setTotalFee(BaseWxPayRequest.yuanToFen(request.getAmount().toString()));
        wxPayUnifiedOrderRequest.setSpbillCreateIp(request.getRequestIp());
        wxPayUnifiedOrderRequest.setOpenid(request.getOpenId());
        // 设置回调地址
        wxPayUnifiedOrderRequest.setNotifyUrl(partyConfigProperties.getServerUrl() + partyConfigProperties.getAliPayCallbackUrl());

        WxAppletResponse response = new WxAppletResponse();
        try {
            WxPayMpOrderResult execute = wxPayService.createOrder(wxPayUnifiedOrderRequest);
            response.setAppId(execute.getAppId());
            response.setPaySign(execute.getPaySign());
            response.setNonceStr(execute.getNonceStr());
            response.setPackageValue(execute.getPackageValue());
            response.setSignType(execute.getSignType());
            response.setTimeStamp(execute.getTimeStamp());
            prePaymentResponse.setWxAppletResponse(response);
        } catch (WxPayException e) {
            log.error("调用微信预支付失败，param:{},exception：", request, e);
            return Message.build(false).setMessage("调用微信预支付失败" + e.getMessage());
        }

        return Message.build().addParam(CommonConstant.RESULT_DTO, prePaymentResponse);
    }

    @Override
    protected PaymentActionEnum matchAction() {
        return PaymentActionEnum.PRE_PAYMENT;
    }

    @Override
    protected PaymentModeEnum matchMode() {
        return PaymentModeEnum.APPLET;
    }

    @Override
    protected PlatformEnum platform() {
        return PlatformEnum.WX;
    }
}
