package com.bxm.thirdparty.platform.adapter.payment.pay.wx.request;

import com.bxm.thirdparty.platform.adapter.payment.request.PaymentRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author lowi
 * @date 2023/3/24 15:30
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WxAppletPrePayRequest extends PaymentRequest {

    @ApiModelProperty("订单id")
    private String orderNo;

    @ApiModelProperty("支付收款的账户")
    private String accountId;

    @ApiModelProperty("支付金额")
    private BigDecimal amount;

    @ApiModelProperty("是否模拟支付，模拟支付为最低金额支付")
    private Boolean mock = Boolean.FALSE;

    @ApiModelProperty(value = "支付请求IP", hidden = true)
    private String requestIp;

    @ApiModelProperty("支付成功后的跳转地址")
    private String returnUrl;

    @ApiModelProperty("微信小程序支付需要")
    private String appId;

    @ApiModelProperty("微信小程序支付需要")
    private String openId;

    @ApiModelProperty("订单标题")
    private String title;

    @ApiModelProperty("订单描述信息，给用户支付的时候看")
    private String orderDescription;

}
