package com.bxm.thirdparty.platform.adapter.payment.refund.ali;

import com.alipay.api.AlipayClient;
import com.alipay.api.domain.AlipayTradeRefundModel;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.thirdparty.payment.facade.PaymentConfigFacadeService;
import com.bxm.thirdparty.platform.adapter.payment.PayPlatformAction;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.refund.ali.request.AlipayRefundRequest;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.response.RefundResponse;
import com.bxm.thirdparty.platform.mapper.PaymentOrderV2Mapper;
import com.bxm.thirdparty.platform.model.entity.PaymentOrderV2Entity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

import static java.math.RoundingMode.HALF_DOWN;

/**
 * @author lowi
 * @date 2023/3/27 10:06
 */
@Component
@Slf4j
public class AlipayRefundOrderAction extends PayPlatformAction<AlipayRefundRequest> {

    @Resource
    private PaymentConfigFacadeService paymentConfigFacadeService;


    @Resource
    private PaymentOrderV2Mapper paymentOrderV2Mapper;

    public static final String ALIPAY_SUCCESS_CODE = "10000";


    @Override
    public Message exec(AlipayRefundRequest request) {

        PaymentOrderV2Entity paymentOrderV2Entity = paymentOrderV2Mapper.getByOrderNo(Long.parseLong(request.getOrderNo()));

        AlipayClient alipayClient = paymentConfigFacadeService.getAliClientByMchId(paymentOrderV2Entity.getAccountId());
        if (Objects.isNull(alipayClient)) {
            return Message.build(false).setMessage("支付账户不存在");
        }

        RefundResponse refundResponse = new RefundResponse();

        AlipayTradeRefundModel model = new AlipayTradeRefundModel();
        model.setTradeNo(paymentOrderV2Entity.getThirdPartyTradeNo());
        model.setOutRequestNo(request.getRequestOrderNo());
        model.setRefundAmount(NumberUtils.format(request.getRefundAmount().setScale(2, HALF_DOWN).floatValue()));
        model.setRefundReason(request.getReason());

        AlipayTradeRefundRequest tradeRefundRequest = new AlipayTradeRefundRequest();
        tradeRefundRequest.setBizModel(model);

        AlipayTradeRefundResponse execute = null;
        try {
            execute = alipayClient.execute(tradeRefundRequest);

            refundResponse.setResult(JSON.toJSONString(execute));
            if (!StringUtils.equals(execute.getCode(), ALIPAY_SUCCESS_CODE)) {
                log.error("支付宝申请退款失败，param:{},execute：{}", request, execute);
            }
            refundResponse.setSuccess(StringUtils.equals(execute.getCode(), ALIPAY_SUCCESS_CODE));
            refundResponse.setErrorMsg(execute.getSubMsg());
            refundResponse.setOutOrderNo(request.getOrderNo());
            refundResponse.setPaymentOrderNo(paymentOrderV2Entity.getOrderNo().toString());
            refundResponse.setRefundOrderNo(request.getRequestOrderNo());
        } catch (Exception e) {
            log.error("支付宝申请退款失败，param:{},exception：", request, e);
            return Message.build(false).setMessage("支付宝申请退款失败," + e.getMessage());
        }
        //支付宝发起退款直接就成功了，如果成功，则更新订单状态
        return Message.build().addParam(CommonConstant.RESULT_DTO, refundResponse);
    }

    @Override
    protected PaymentActionEnum matchAction() {
        return PaymentActionEnum.REFUND;
    }

    @Override
    protected PlatformEnum platform() {
        return PlatformEnum.ALI;
    }
}
