package com.bxm.thirdparty.platform.adapter.payment.refund.wx.request;

import com.bxm.thirdparty.platform.adapter.payment.request.PaymentRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author lowi
 * @date 2023/3/24 15:30
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WxRefundRequest extends PaymentRequest {
    /**
     * 业务方申请退款的订单号，可以不传
     */
    private String refundOrderNo;

    /**
     * 内部封装服务交易号，和商户订单号不能同时为空
     */
    private String orderNo;

    /**
     * 订单支付时传入的商户订单号,和支付宝交易号不能同时为空。
     * orderNo,outTrackNo如果同时存在优先取orderNo
     */
    private String outTrackNo;

    /**
     * 退款金额，不传，默认退全款
     */
    private BigDecimal refundAmount;

    /**
     * 支付请求IP
     */
    private String requestIp;

    /**
     * 退款理由
     */
    private String reason;
}

