package com.bxm.thirdparty.platform.adapter.payment.withdraw.ali.param;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author gonzo
 * @date 2020-08-11 13:58
 **/
@Data
public class AlipayFundTransUniTransferParam {

    /**
     * String	必选	64	商户端的唯一订单号，对于同一笔转账请求，商户需保证该订单号唯一。
     * 201806300001
     */
    @JSONField(name = "out_biz_no")
    private String outBizNo;

    /**
     * Price	必选	20	订单总金额，单位为元，精确到小数点后两位，
     * STD_RED_PACKET产品取值范围[0.01,100000000]；
     * TRANS_ACCOUNT_NO_PWD产品取值范围[0.1,100000000]
     * 23.00
     */
    @JSONField(name = "trans_amount")
    private BigDecimal transAmount;

    /**
     * String	必选	64
     * 业务产品码
     * 单笔无密转账到支付宝账户固定为:
     * TRANS_ACCOUNT_NO_PWD；
     * 单笔无密转账到银行卡固定为:
     * TRANS_BANKCARD_NO_PWD;
     * 收发现金红包固定为:
     * STD_RED_PACKET；
     * <p>
     * TRANS_ACCOUNT_NO_PWD
     */
    @JSONField(name = "product_code")
    private String productCode;

    /**
     * String	可选	64	描述特定的业务场景，可传的参数如下：
     * DIRECT_TRANSFER：单笔无密转账到支付宝/银行卡, B2C现金红包;
     * PERSONAL_COLLECTION：C2C现金红包-领红包
     * <p>
     * DIRECT_TRANSFER
     */
    @JSONField(name = "biz_scene")
    private String bizScene;

    /**
     * String	可选	64	转账业务的标题，用于在支付宝用户的账单里显示
     * 转账标题
     */
    @JSONField(name = "order_title")
    private String orderTitle;

    /**
     * String	可选	64	原支付宝业务单号。C2C现金红包-红包领取时，传红包支付时返回的支付宝单号；B2C现金红包、单笔无密转账到支付宝/银行卡不需要该参数。	20190620110075000006640000063056
     */
    @JSONField(name = "original_order_id")
    private String originalOrderId;

    /**
     * 必选		收款方信息
     */
    @JSONField(name = "payee_info")
    private AlipayFundTransUniTransferPayeeInfoParam payeeInfo;

    /**
     * String	可选	200	业务备注	单笔转账
     */
    @JSONField(name = "remark")
    private String remark;

    /**
     * String	可选	2048	转账业务请求的扩展参数，支持传入的扩展参数如下：
     * 1、sub_biz_scene 子业务场景，红包业务必传，取值REDPACKET，C2C现金红包、B2C现金红包均需传入；
     * 2、withdraw_timeliness为转账到银行卡的预期到账时间，可选（不传入则默认为T1），取值T0表示预期T+0到账，取值T1表示预期T+1到账，因到账时效受银行机构处理影响，支付宝无法保证一定是T0或者T1到账；	{"sub_biz_scene":"REDPACKET"}
     */
    @JSONField(name = "business_params")
    private String businessParams;

}

