package com.bxm.thirdparty.platform.adapter.payment.withdraw.wx;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.payment.facade.PaymentConfigFacadeService;
import com.bxm.thirdparty.platform.adapter.payment.PayPlatformAction;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.withdraw.wx.request.WxWithdrawRequest;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.response.WithdrawResponse;
import com.github.binarywang.wxpay.bean.entpay.EntPayRequest;
import com.github.binarywang.wxpay.bean.entpay.EntPayResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/3/27 10:06
 */
@Component
@Slf4j
public class WxWithdrawAction extends PayPlatformAction<WxWithdrawRequest> {

    @Resource
    private PaymentConfigFacadeService paymentConfigFacadeService;

    @Override
    public Message exec(WxWithdrawRequest request) {
        WxPayService wxPayService = paymentConfigFacadeService.getWxClientByMchId(request.getAccountId());
        if (Objects.isNull(wxPayService)) {
            return Message.build(false).setMessage("提现账户不存在");
        }

        WithdrawResponse withdrawResponse = new WithdrawResponse();

        EntPayRequest entPayRequest = new EntPayRequest();
        entPayRequest.setAmount(BaseWxPayRequest.yuanToFen(request.getAmount().toString()));
        entPayRequest.setAppid(request.getAppId());
        entPayRequest.setOpenid(request.getIdentity());
        entPayRequest.setCheckName("NO_CHECK");
        entPayRequest.setDescription(request.getRemark());
        entPayRequest.setPartnerTradeNo(request.getRequestOrderNo().toString());
        entPayRequest.setSpbillCreateIp(request.getRequestIp());

        try {
            EntPayResult result = wxPayService.getEntPayService().entPay(entPayRequest);

            withdrawResponse.setResult(JSON.toJSONString(result));
            if (Objects.equals(result.getReturnCode(), CommonConstant.WECHAT_SUCCSS_CODE) && Objects.equals(result.getResultCode(), CommonConstant.WECHAT_SUCCSS_CODE)) {
                withdrawResponse.setSuccess(true);
            } else {
                withdrawResponse.setSuccess(false);
                withdrawResponse.setErrorMsg(result.getReturnMsg());
            }
            withdrawResponse.setOutOrderNo(request.getOrderNo());
            withdrawResponse.setWithdrawOrderNo(request.getRequestOrderNo().toString());
        } catch (WxPayException e) {
            log.error(e.getMessage(), e);
            log.error("发起提现失败，请求参数为：{}", request);
            return Message.build(false).setMessage("微信提现失败：" + e.getErrCodeDes());
        }
        return Message.build().addParam(CommonConstant.RESULT_DTO, withdrawResponse);
    }

    @Override
    protected PaymentActionEnum matchAction() {
        return PaymentActionEnum.TRANSFERS;
    }


    @Override
    protected PlatformEnum platform() {
        return PlatformEnum.WX;
    }
}
