package com.bxm.thirdparty.platform.adapter.payment.withdraw.wx.request;

import com.bxm.thirdparty.platform.adapter.payment.request.PaymentRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author lowi
 * @date 2023/3/24 15:30
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WxWithdrawRequest extends PaymentRequest {

    /**
     * 提现平台 ALI  WX
     */
    private String payPlatform;

    /**
     * 被提现的商户id
     */
    private String accountId;

    /**
     * 订单编号
     */
    private String orderNo;


    /**
     * 提现金额
     */
    private BigDecimal amount;

    /**
     * 提现备注信息
     */
    private String remark;

    /**
     * 提现显示的标题
     */
    private String title;

    /**
     * 请求来源IP
     */
    private String requestIp;


    /**
     * 用户唯一标志，ALI平台 则为阿里账户
     * WX则为openId
     */
    private String identity;

    /**
     * wx提现需要提供appId
     */
    private String appId;

}
