package com.bxm.thirdparty.platform.before.chargephone;

import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.before.IBeforeThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.enums.PlatformBusinessTypeEnum;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.request.ChargePhoneRequest;
import com.bxm.thirdparty.platform.mapper.ChargesPhoneLogMapper;
import com.bxm.thirdparty.platform.model.entity.ChargesPhoneLogEntity;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/4/6 11:11
 */
@Component
public class BeforeChargePhoneAction implements IBeforeThirdPartyPlatformAction<ChargePhoneRequest, ChargesPhoneLogEntity> {


    @Resource
    private SequenceCreater sequenceCreater;

    @Resource
    ChargesPhoneLogMapper chargesPhoneLogMapper;

    @Resource
    private ThirdPartyConfigProperties configProperties;


    @Override
    public Class<?> support() {
        return ChargePhoneRequest.class;
    }

    @Override
    public Message validationArgs(PlatformContext<ChargePhoneRequest, ChargesPhoneLogEntity> context) {
        ChargePhoneRequest request = context.getRequest();

        String channel = request.getChannel() == null ? configProperties.getDefaultChargePhoneChannel() : request.getChannel();
        request.setChannel(channel);
        if (Objects.isNull(request.getMoney())
                || Objects.isNull(request.getOrderNo())
                || Objects.isNull(request.getPhoneNo())
                || Objects.isNull(request.getApplicationName())) {
            return Message.build(false).setMessage("参数缺失");
        }

        List<String> platformListByBusinessType = PlatformEnum.getPlatformListByBusinessType(PlatformBusinessTypeEnum.CHARGE_PHONE);
        if (!platformListByBusinessType.contains(channel)) {
            return Message.build(false).setMessage(channel + "话费充值平台暂未实现");
        }
        context.setMock(request.getMock());
        context.setSync(Boolean.FALSE);
        return Message.build();
    }

    @Override
    public void insertInfo(PlatformContext<ChargePhoneRequest, ChargesPhoneLogEntity> context) {
        ChargePhoneRequest request = context.getRequest();

        ChargesPhoneLogEntity chargesPhoneLogEntity = new ChargesPhoneLogEntity();
        chargesPhoneLogEntity.setId(sequenceCreater.nextLongId());
        chargesPhoneLogEntity.setOrderNo(SequenceHolder.nextLongId());
        chargesPhoneLogEntity.setOutOrderNo(request.getOrderNo());
        chargesPhoneLogEntity.setPhone(request.getPhoneNo());
        chargesPhoneLogEntity.setCreateTime(new Date());
        chargesPhoneLogEntity.setPayPrice(request.getMoney());
        chargesPhoneLogEntity.setMock(request.getMock() ? 1 : 0);
        chargesPhoneLogEntity.setPlatform(request.getChannel());
        chargesPhoneLogEntity.setApplicationName(request.getApplicationName());
        chargesPhoneLogEntity.setRequestId(ThreadContext.getRequestId());
        chargesPhoneLogMapper.insert(chargesPhoneLogEntity);

        context.setOrderInfo(chargesPhoneLogEntity);
    }
}
