package com.bxm.thirdparty.platform.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author lowi
 * @date 2023/4/6 16:21
 */
@Data
@ConfigurationProperties(prefix = "server.notify.config")
@Component
public class ServerNotifyProperties {

    /**
     * 重试间隔数组
     * 每次失败后间隔多少秒进行重试
     */
    private int[] retryIntervalArray = {
            5,
            10,
            30,
            60,
            300,
            1500
    };

    /**
     * 队列执行线程数量
     */
    private int queueExecutorNum = 6;

}
