package com.bxm.thirdparty.platform.config;

import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author lowi
 * @date 2023/3/24 14:13
 */
@Data
@Component
@ConfigurationProperties("thirdparty.config")
public class ThirdPartyConfigProperties {

    /**
     * 通知服务器模拟，测试通知其他服务mock成功
     */
    private Boolean notifyServerMocK = Boolean.FALSE;

    private String serverUrl = "";

    private String aliPayCallbackUrl = "/v1/3rd/public/callback/alipay/trade";

    private String wxRefundCallbackUrl = "/v1/3rd/public/callback/wechat/refund";

    private String xinRongCallbackUrl = "/v1/3rd/public/callback/xinrong";

    private String liBaCallbackUrl = "/v1/3rd/public/callback/liba";

    private String defaultChargePhonePlatform = "XIN_RONG";

    private String defaultElectricPlatform = "LI_BA";

    private String liBaAppId = "nyvpbisq2b";

    private String liBaAppKey = "0d3eef147126cb0c45fcee64557f07b5";

    private String liBaCheckAccountApi = "http://47.94.184.147/api/amount/server";

    private String liBaCreateOrderApi = "http://47.94.184.147/api/rechargecable/server";

    /**
     * 商户在系统中开设的唯一编号
     */
    private String xinRongClientId = "GoDaNquWoXQjda6Vrx44";

    /**
     * 默认充话费渠道
     */
    private String defaultChargePhoneChannel = PlatformEnum.XIN_RONG.name();

    /**
     * 默认充电费渠道
     */
    private String defaultElectricChannel = PlatformEnum.LI_BA.name();

    /**
     *
     */
    private String xinRongClientSecret = "wWkKq1frq8UaaQfXd8Eq2uTPj";

    /**
     * 3.1	充值下单
     */
    private String xinRongCreateOrder = "http://47.118.69.121/createorder.html";

    /**
     * 3.3	账户查询
     */
    private String xinRongCheckAccount = "http://47.118.69.121/createorder.html";

    /**
     * 移动号码分段
     */
    private List<String> movePhoneParagraph = Lists.newArrayList(
            "134",
            "135",
            "136",
            "137",
            "138",
            "139",
            "147",
            "150",
            "151",
            "152",
            "157",
            "158",
            "159",
            "178",
            "182",
            "183",
            "184",
            "187",
            "188",
            "195",
            "198");


    /**
     * 联通号码分段
     */
    private List<String> umPhoneParagraph = Lists.newArrayList(
            "130",
            "131",
            "132",
            "145",
            "155",
            "156",
            "166",
            "175",
            "176",
            "185",
            "186",
            "196");


    /**
     * 电信号码分段
     */
    private List<String> tmPhoneParagraph = Lists.newArrayList(
            "133",
            "153",
            "173",
            "177",
            "180",
            "181",
            "189",
            "190",
            "191",
            "193",
            "199");
}
