package com.bxm.thirdparty.platform.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author lowi
 * @date 2023/4/6 14:48
 */
@Getter
public enum PaymentOrderStatusEnum {


    /**
     * 等待支付
     */
    WAIT(1),

    /**
     * 取消付款
     */
    CANCEL(2),

    /**
     * 支付成功
     */
    SUCCESS(3),

    /**
     * 支付失败
     */
    FAIL(4),

    /**
     * 支付超时
     */
    TIMEOUT(5),

    /**
     * 退款中
     */
    REFUND_ING(6),

    /**
     * 已退款
     */
    REFUNDED(7),

    /**
     * 退款失败
     */
    REFUND_FAIL(8),
    ;

    private int code;

    PaymentOrderStatusEnum(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public boolean match(int code) {
        return Objects.equals(code, this.code);
    }
}
