package com.bxm.thirdparty.platform.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author lowi
 * @date 2023/4/6 14:48
 */
@Getter
public enum PaymentWithdrawStatusEnum {


    /**
     * 等待处理
     */
    WAITING(0),

    /**
     * 调用成功
     */
    SUCCEED(1),

    /**
     * 调用失败
     */
    FAILED(2),
    ;

    private int code;

    PaymentWithdrawStatusEnum(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public boolean match(int code) {
        return Objects.equals(code, this.code);
    }
}
