package com.bxm.thirdparty.platform.enums;

import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * @author lowi
 * @date 2023/3/24 10:05
 */
@Getter
public enum PlatformEnum {
    /**
     * 支付宝
     */
    ALI(PlatformBusinessTypeEnum.PAYMENT),
    /**
     * 微信app
     */
    WX(PlatformBusinessTypeEnum.PAYMENT),
    /**
     * 第三方支付平台ums
     */
    UMS(PlatformBusinessTypeEnum.PAYMENT),

    /**
     * 心融话费平台
     */
    XIN_RONG(PlatformBusinessTypeEnum.CHARGE_PHONE),

    /**
     * 力拔
     */
    LI_BA(PlatformBusinessTypeEnum.ELECTRIC);

    private PlatformBusinessTypeEnum businessTypeEnum;

    PlatformEnum(PlatformBusinessTypeEnum businessTypeEnum) {
        this.businessTypeEnum = businessTypeEnum;
    }

    public static List<String> getPlatformListByBusinessType(PlatformBusinessTypeEnum typeEnum) {
        List<String> platformList = new ArrayList<>();
        for (PlatformEnum value : values()) {
            if (value.getBusinessTypeEnum().equals(typeEnum)) {
                platformList.add(value.name());
            }
        }
        return platformList;
    }

    public static PlatformEnum get(String platform) {
        for (PlatformEnum value : values()) {
            if (value.name().equals(platform)) {
                return value;
            }
        }
        return null;
    }
}
