package com.bxm.thirdparty.platform.interceptor;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lowi
 * @date 2023/3/17 13:46
 */
@Slf4j
@Component
public class IInterceptorExecutor {

    private Map<String, IThirdPartyInterceptor> interceptorMap = new HashMap<>();

    public IInterceptorExecutor(List<IThirdPartyInterceptor> interceptors) {
        for (IThirdPartyInterceptor interceptor : interceptors) {
            interceptorMap.put(interceptor.getClass().getSimpleName(), interceptor);
        }
    }

    public <T extends BaseRequest> Message accept(Class<? extends IThirdPartyInterceptor> interceptorClass, T t) {
        IThirdPartyInterceptor iThirdPartyInterceptor = interceptorMap.get(interceptorClass.getSimpleName());

        if (iThirdPartyInterceptor == null) {
            log.error("定义的拦截器[{}]不存在，请确定是否注册到spring上下文", iThirdPartyInterceptor);
            return Message.build(true);
        }

        return iThirdPartyInterceptor.accept(t);
    }
}
