package com.bxm.thirdparty.platform.queue;

import com.bxm.thirdparty.platform.context.FailInfoContext;
import com.bxm.thirdparty.platform.enums.FailEnum;
import com.bxm.thirdparty.platform.queue.bo.QueueBO;

/**
 * @author lowi
 * @date 2023/4/6 15:38
 */

public interface QueueService {

    /**
     * 业务提交
     *
     * @param queueBO 队列博
     */
    void submitBusinessNotify(QueueBO queueBO);

    /**
     * 更新通知信息成功
     *
     * @param requestId 跟踪id
     */
    void updateNotifyInfoSuccess(String requestId);

    /**
     * 添加业务失败信息
     *
     * @param requestId      跟踪id
     * @param toJSONString jsonstring
     * @param errorMsg     错误信息
     */
    void addBusinessFailInfo(String requestId, String toJSONString, String errorMsg);
}
