package com.bxm.thirdparty.platform.service;

/**
 * @author lowi
 * @date 2023/4/7 13:41
 */

public interface PaymentService {


    /**
     * 更新退款订单成功
     *
     * @param refundOrderNo 退款订单
     */
    void updateRefundOrderSuccess(Long refundOrderNo);

    /**
     * 更新退款订单退款中
     *
     * @param refundOrderNo 退款订单
     */
    void updateRefundOrderRefundIng(Long refundOrderNo);

    /**
     * 更新退款订单失败
     *
     * @param refundOrderNo 退款订单
     */
    void updateRefundOrderFail(Long refundOrderNo, String errorMsg);

    /**
     * 更新提现订单成功
     *
     * @param orderNo 请求id
     */
    void updateWithdrawOrderSuccess(Long orderNo);

    /**
     * 更新提现订单失败
     *
     * @param orderNo  订单没有
     * @param errorMsg 错误信息
     */
    void updateWithdrawOrderFail(Long orderNo, String errorMsg);
}
