package com.bxm.thirdparty.platform.service.impl;

import com.bxm.thirdparty.platform.enums.PaymentOrderStatusEnum;
import com.bxm.thirdparty.platform.enums.PaymentRefundStatusEnum;
import com.bxm.thirdparty.platform.enums.PaymentWithdrawStatusEnum;
import com.bxm.thirdparty.platform.mapper.PaymentOrderV2Mapper;
import com.bxm.thirdparty.platform.mapper.PaymentRefundV2Mapper;
import com.bxm.thirdparty.platform.mapper.PaymentWithdrawFlowV2Mapper;
import com.bxm.thirdparty.platform.model.entity.PaymentOrderV2Entity;
import com.bxm.thirdparty.platform.model.entity.PaymentRefundV2Entity;
import com.bxm.thirdparty.platform.model.entity.PaymentWithdrawFlowV2Entity;
import com.bxm.thirdparty.platform.service.PaymentService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/4/7 13:41
 */
@Slf4j
@AllArgsConstructor
@Service
public class PaymentServiceImpl implements PaymentService {

    private final PaymentRefundV2Mapper paymentRefundV2Mapper;

    private final PaymentOrderV2Mapper paymentOrderV2Mapper;

    private final PaymentWithdrawFlowV2Mapper paymentWithdrawFlowV2Mapper;


    @Override
    public void updateRefundOrderSuccess(Long refundOrderNo) {
        PaymentRefundV2Entity paymentRefundV2Entity = paymentRefundV2Mapper.getByRefundOrderNo(refundOrderNo);
        if (Objects.isNull(paymentRefundV2Entity)) {
            log.error("更新退款订单成功，但退款订单不存在：{}", refundOrderNo);
            return;
        }
        PaymentRefundV2Entity updateClass = new PaymentRefundV2Entity();
        updateClass.setId(paymentRefundV2Entity.getId());
        updateClass.setStatus(PaymentRefundStatusEnum.REFUNDED.getCode());
        updateClass.setRefundTime(new Date());
        updateClass.setModifyTime(new Date());
        paymentRefundV2Mapper.updateById(updateClass);

        PaymentOrderV2Entity orderV2Entity = paymentOrderV2Mapper.getByOrderNo(paymentRefundV2Entity.getPaymentOrderNo());

        PaymentOrderV2Entity updateOrderClass = new PaymentOrderV2Entity();
        updateOrderClass.setId(paymentRefundV2Entity.getId());
        updateOrderClass.setStatus(PaymentOrderStatusEnum.REFUNDED.getCode());
        updateOrderClass.setModifyTime(new Date());
        paymentOrderV2Mapper.updateById(orderV2Entity);
    }

    @Override
    public void updateRefundOrderRefundIng(Long refundOrderNo) {
        PaymentRefundV2Entity paymentRefundV2Entity = paymentRefundV2Mapper.getByRefundOrderNo(refundOrderNo);
        if (Objects.isNull(paymentRefundV2Entity)) {
            log.error("更新退款订单成功，但退款订单不存在：{}", refundOrderNo);
            return;
        }

        PaymentOrderV2Entity orderV2Entity = paymentOrderV2Mapper.getByOrderNo(paymentRefundV2Entity.getPaymentOrderNo());

        PaymentOrderV2Entity updateOrderClass = new PaymentOrderV2Entity();
        updateOrderClass.setId(paymentRefundV2Entity.getId());
        updateOrderClass.setStatus(PaymentOrderStatusEnum.REFUND_ING.getCode());
        updateOrderClass.setModifyTime(new Date());
        paymentOrderV2Mapper.updateById(orderV2Entity);
    }

    @Override
    public void updateRefundOrderFail(Long refundOrderNo, String errorMsg) {
        PaymentRefundV2Entity paymentRefundV2Entity = paymentRefundV2Mapper.getByRefundOrderNo(refundOrderNo);
        if (Objects.isNull(paymentRefundV2Entity)) {
            log.error("更新退款订单成功，但退款订单不存在：{}", refundOrderNo);
            return;
        }
        PaymentRefundV2Entity updateClass = new PaymentRefundV2Entity();
        updateClass.setId(paymentRefundV2Entity.getId());
        updateClass.setStatus(PaymentRefundStatusEnum.REFUND_FAIL.getCode());
        updateClass.setRefundTime(new Date());
        updateClass.setModifyTime(new Date());
        updateClass.setRemark(errorMsg);
        paymentRefundV2Mapper.updateById(updateClass);

        PaymentOrderV2Entity orderV2Entity = paymentOrderV2Mapper.getByOrderNo(paymentRefundV2Entity.getPaymentOrderNo());

        PaymentOrderV2Entity updateOrderClass = new PaymentOrderV2Entity();
        updateOrderClass.setId(paymentRefundV2Entity.getId());
        updateOrderClass.setStatus(PaymentOrderStatusEnum.REFUND_FAIL.getCode());
        updateOrderClass.setModifyTime(new Date());
        paymentOrderV2Mapper.updateById(orderV2Entity);
    }

    @Override
    public void updateWithdrawOrderSuccess(Long orderNo) {
        PaymentWithdrawFlowV2Entity paymentWithdrawFlowV2Entity = paymentWithdrawFlowV2Mapper.getByWithdrawOrderNo(orderNo);

        if (Objects.isNull(paymentWithdrawFlowV2Entity)) {
            log.error("更新提现订单成功，但提现订单不存在：{}", orderNo);
            return;
        }

        PaymentWithdrawFlowV2Entity updateOrderClass = new PaymentWithdrawFlowV2Entity();
        updateOrderClass.setId(paymentWithdrawFlowV2Entity.getId());
        updateOrderClass.setStatus(PaymentWithdrawStatusEnum.SUCCEED.getCode());
        updateOrderClass.setModifyTime(new Date());
        updateOrderClass.setWithdrawTime(new Date());
        paymentWithdrawFlowV2Mapper.updateById(updateOrderClass);
    }

    @Override
    public void updateWithdrawOrderFail(Long orderNo, String errorMsg) {
        PaymentWithdrawFlowV2Entity paymentWithdrawFlowV2Entity = paymentWithdrawFlowV2Mapper.getByWithdrawOrderNo(orderNo);

        if (Objects.isNull(paymentWithdrawFlowV2Entity)) {
            log.error("更新提现订单失败，但提现订单不存在：{},error:{}", orderNo, errorMsg);
            return;
        }

        PaymentWithdrawFlowV2Entity updateOrderClass = new PaymentWithdrawFlowV2Entity();
        updateOrderClass.setId(paymentWithdrawFlowV2Entity.getId());
        updateOrderClass.setStatus(PaymentWithdrawStatusEnum.FAILED.getCode());
        updateOrderClass.setModifyTime(new Date());
        updateOrderClass.setWithdrawTime(new Date());
        updateOrderClass.setErrorMsg(errorMsg);
        paymentWithdrawFlowV2Mapper.updateById(updateOrderClass);
    }
}
