package com.bxm.thirdparty.platform.timer;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.schedule.AbstractCronXxlJob;
import com.bxm.thirdparty.platform.mapper.BusinessNotifyLogMapper;
import com.bxm.thirdparty.platform.model.entity.BusinessNotifyLogEntity;
import com.bxm.thirdparty.platform.queue.NotifyQueueCacheHolder;
import com.bxm.thirdparty.platform.queue.bo.QueueBO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * 添加通知信息到队列
 *
 * @author lowi
 * @date 2023/3/10 13:21
 */
@Component
@Slf4j
public class AddBusinessNotifyTask extends AbstractCronXxlJob {

    @Resource
    private BusinessNotifyLogMapper notifyLogMapper;

    @Resource
    private NotifyQueueCacheHolder cacheHolder;

    private final static int LIMIT = 100;


    @Override
    public void executeLogic() {
        loop(0L);
    }

    private void loop(Long lastRecordId) {
        //只取待处理的数据
        List<BusinessNotifyLogEntity> readyList = notifyLogMapper.queryReadyItemList(0L, LIMIT);

        for (BusinessNotifyLogEntity entity : readyList) {
            String request = entity.getRequest();
            QueueBO queueBO = JSON.parseObject(request, QueueBO.class);
            //待处理的数据更新成队列中，等待执行
            BusinessNotifyLogEntity updateClass = new BusinessNotifyLogEntity();
            updateClass.setId(entity.getId());
            updateClass.setStatus(1);
            updateClass.setModifyTime(new Date());
            notifyLogMapper.updateById(updateClass);
            //放入队列
            cacheHolder.addToQueue(queueBO);
        }

        if (readyList.size() >= LIMIT) {
            loop(readyList.get(readyList.size() - 1).getId());
        }
    }

    @Override
    protected String cron() {
        return "0/5 * * * * ?";
    }

    @Override
    public String jobDesc() {
        return "执行业务通知";
    }

    @Override
    public String author() {
        return "lowi";
    }
}
