package com.bxm.thirdparty.platform.timer;

import com.bxm.newidea.component.schedule.AbstractCronXxlJob;
import com.bxm.thirdparty.platform.queue.NotifyQueueCacheHolder;
import com.bxm.thirdparty.platform.queue.NotifyQueueExecutor;
import com.bxm.thirdparty.platform.queue.bo.QueueBO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/3/10 13:21
 */
@Component
@Slf4j
public class BusinessNotifyTask extends AbstractCronXxlJob {

    @Resource
    private NotifyQueueExecutor notifyQueueExecutor;

    @Resource
    private NotifyQueueCacheHolder queueCacheHolder;


    @Override
    public void executeLogic() {
        loopFetch();
    }

    private void loopFetch() {
        QueueBO queueBO = queueCacheHolder.pop();
        if (Objects.nonNull(queueBO)) {
            if (notifyQueueExecutor.isFullLoad()) {
                queueCacheHolder.addToQueue(queueBO);
            } else {
                notifyQueueExecutor.executor(queueBO);
            }
            loopFetch();
        }
    }

    @Override
    protected String cron() {
        return "0/5 * * * * ?";
    }

    @Override
    public String jobDesc() {
        return "执行业务通知";
    }

    @Override
    public String author() {
        return "lowi";
    }
}
