package com.bxm.thirdparty.platform.utils;

import cn.hutool.core.util.IdUtil;
import com.bxm.thirdparty.platform.context.ThreadContext;
import org.slf4j.MDC;

/**
 * @author lowi
 * @date 2023/4/8 16:01
 */
public class TraceUtil {

    public static void traceStart() {
        String clientIp = ThreadContext.getClientIp();
        ThreadContext.init();
        String requestId = generateRequestId();
        MDC.put(ThreadContext.REQUEST_ID_KEY, requestId);
        MDC.put(ThreadContext.CLIENT_IP_KEY, clientIp);
        ThreadContext.putRequestId(requestId);
    }

    public static void traceEnd() {
        MDC.clear();
        ThreadContext.clean();
    }

    public static void replaceRequestId(String requestId) {
        MDC.put(ThreadContext.REQUEST_ID_KEY, requestId);
        ThreadContext.putRequestId(requestId);
    }

    /**
     * 生成跟踪ID
     *
     * @return
     */
    private static String generateRequestId() {
        return IdUtil.randomUUID();
    }
}
