package com.bxm.thirdparty.platform.adapter.electric.liba;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.adapter.electric.ElectricAction;
import com.bxm.thirdparty.platform.adapter.electric.liba.bo.LiBaBO;
import com.bxm.thirdparty.platform.adapter.electric.liba.bo.LiBaCreateOrderResultBO;
import com.bxm.thirdparty.platform.adapter.electric.liba.utils.LiBaUtil;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.request.ElectricRequest;
import com.bxm.thirdparty.platform.facade.response.ElectricTopUpResponse;
import com.bxm.thirdparty.platform.model.entity.ElectricLogEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/4/6 19:05
 */
@Component
@Slf4j
public class LiBaElectricAction implements ElectricAction<ElectricRequest, ElectricLogEntity> {

    @Resource
    private ThirdPartyConfigProperties thirdPartyConfigProperties;

    @Override
    public PlatformEnum support() {
        return PlatformEnum.LI_BA;
    }

    @Override
    public Message exec(PlatformContext<ElectricRequest, ElectricLogEntity> context) {
        ElectricRequest liBaRequest = context.getRequest();
        ElectricLogEntity orderInfo = context.getOrderInfo();

        LiBaUtil libaUtil = new LiBaUtil(thirdPartyConfigProperties);
        //充值前先判断余额充足不充足
        if (libaUtil.checkAccount().compareTo(liBaRequest.getAmount()) < 0) {
            log.error("liba话费充值失败，充值余额不足：{}", context);
            return Message.build(false).setMessage("充值余额不足");
        }

        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("account", liBaRequest.getAccount());
        paramMap.put("orderId", orderInfo.getOrderNo());
        paramMap.put("amount", liBaRequest.getAmount());
        paramMap.put("notifyUrl", thirdPartyConfigProperties.getServerUrl() + thirdPartyConfigProperties.getLiBaCallbackUrl());
        paramMap.put("province", liBaRequest.getProvince());
        paramMap.put("city", liBaRequest.getCity());
        String body = libaUtil.createOrder(paramMap);
        if (Objects.isNull(body)) {
            log.error("liba话费充值失败，返回信息不存在：{}", context);
            return Message.build(false).setMessage("调用第三方电费充值失败");
        }
        LiBaBO liBaBO = JSON.parseObject(body, LiBaBO.class);
        log.info("力拔电费充值信息request：{},result:{}", context, body);
        if (!Objects.equals(liBaBO.getReturnCode(), 200)) {
            return Message.build(false).setMessage(liBaBO.getReturnMsg());
        }
        LiBaCreateOrderResultBO liBaCreateOrderResultBO = JSON.parseObject(JSON.toJSONString(liBaBO.getData()), LiBaCreateOrderResultBO.class);
        ElectricTopUpResponse response = new ElectricTopUpResponse();
        response.setRequestId(ThreadContext.getRequestId());
        response.setSuccess(true);
        response.setAccount(liBaCreateOrderResultBO.getAccount());
        response.setAmount(liBaCreateOrderResultBO.getAmount());
        response.setResult(JSON.toJSONString(liBaBO));
        response.setOrderNo(orderInfo.getOrderNo().toString());
        response.setOutOrderNo(liBaRequest.getOrderNo());
        return Message.build().addParam(CommonConstant.RESULT_DTO, response);
    }
}
