package com.bxm.thirdparty.platform.adapter.payment.enums;

import lombok.Getter;

/**
 * 提现状态枚举
 *
 * @author liujia
 * @date 7/7/21 3:44 PM
 **/
@Getter
public enum WithdrawStatusEnum {

    /**
     * 等待处理
     */
    WAITING(0),

    /**
     * 调用成功
     */
    SUCCEED(1),

    /**
     * 调用失败
     */
    FAILED(2),

    ;

    private int code;

    WithdrawStatusEnum(int code) {
        this.code = code;
    }


    public static WithdrawStatusEnum get(int code) {
        for (WithdrawStatusEnum statusEnum : WithdrawStatusEnum.values()) {
            if (statusEnum.getCode() == code) {
                return statusEnum;
            }
        }

        return null;
    }

}
