package com.bxm.thirdparty.platform.adapter.payment.pay.wx;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.payment.facade.PaymentConfigFacadeService;
import com.bxm.thirdparty.platform.adapter.payment.PayPlatformAction;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentModeEnum;
import com.bxm.thirdparty.platform.adapter.payment.pay.wx.request.WxH5PrePayRequest;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.response.PrePaymentResponse;
import com.github.binarywang.wxpay.bean.order.WxPayMwebOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.constant.WxPayConstants;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/3/27 10:06
 */
@Component
@Slf4j
public class WxH5PreOrderAction extends PayPlatformAction<WxH5PrePayRequest> {

    @Resource
    private PaymentConfigFacadeService paymentConfigFacadeService;

    @Resource
    private ThirdPartyConfigProperties partyConfigProperties;

    @Override
    public Message exec(WxH5PrePayRequest request) {
        WxPayService wxPayService = paymentConfigFacadeService.getWxClientByAppIdAndMchId(request.getAppId(),request.getAccountId());

        if (Objects.isNull(wxPayService)) {
            return Message.build(false).setMessage("支付账户不存在");
        }

        PrePaymentResponse prePaymentResponse = new PrePaymentResponse();
        prePaymentResponse.setRequestId(ThreadContext.getRequestId());
        if (request.getMock()) {
            prePaymentResponse.setSuccess(true);
            return Message.build().addParam(CommonConstant.RESULT_DTO, prePaymentResponse);
        }

        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = new WxPayUnifiedOrderRequest();

        wxPayUnifiedOrderRequest.setDeviceInfo("WEB");
        wxPayUnifiedOrderRequest.setOutTradeNo(request.getRequestOrderNo());
        wxPayUnifiedOrderRequest.setBody(request.getOrderDescription());
        wxPayUnifiedOrderRequest.setTotalFee(BaseWxPayRequest.yuanToFen(request.getAmount().toString()));
        wxPayUnifiedOrderRequest.setSpbillCreateIp(request.getRequestIp());
        wxPayUnifiedOrderRequest.setTradeType(WxPayConstants.TradeType.MWEB);
        // 设置回调地址
        wxPayUnifiedOrderRequest.setNotifyUrl(partyConfigProperties.getServerUrl() + partyConfigProperties.getWxPayCallbackUrl() + "/" + request.getAccountId() + "/" + request.getRequestOrderNo());

        try {
            WxPayMwebOrderResult execute = wxPayService.createOrder(wxPayUnifiedOrderRequest);
            prePaymentResponse.setLink(execute.getMwebUrl());
            prePaymentResponse.setSuccess(true);
        } catch (WxPayException e) {
            log.error("调用微信H5预支付失败，param:{},exception：", request, e);
            return Message.build(false).setMessage("调用微信H5预支付失败" + e.getMessage());
        }

        return Message.build().addParam(CommonConstant.RESULT_DTO, prePaymentResponse);
    }

    @Override
    protected PaymentActionEnum matchAction() {
        return PaymentActionEnum.PRE_PAYMENT;
    }

    @Override
    protected PaymentModeEnum matchMode() {
        return PaymentModeEnum.H5;
    }

    @Override
    protected PlatformEnum platform() {
        return PlatformEnum.WX;
    }
}
