package com.bxm.thirdparty.platform.before.electric;

import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.before.IBeforeThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.enums.PlatformBusinessTypeEnum;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.request.ChargePhoneRequest;
import com.bxm.thirdparty.platform.facade.request.ElectricRequest;
import com.bxm.thirdparty.platform.mapper.ElectricLogMapper;
import com.bxm.thirdparty.platform.model.entity.ChargesPhoneLogEntity;
import com.bxm.thirdparty.platform.model.entity.ElectricLogEntity;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/4/6 11:11
 */
@Component
public class BeforeElectricAction implements IBeforeThirdPartyPlatformAction<ElectricRequest, ElectricLogEntity> {


    @Resource
    private SequenceCreater sequenceCreater;

    @Resource
    private ThirdPartyConfigProperties configProperties;

    @Resource
    private ElectricLogMapper electricLogMapper;


    @Override
    public Class<?> support() {
        return ElectricRequest.class;
    }

    @Override
    public Message validationArgs(PlatformContext<ElectricRequest, ElectricLogEntity> context) {
        ElectricRequest request = context.getRequest();

        String channel = request.getChannel() == null ? configProperties.getDefaultChargePhoneChannel() : request.getChannel();
        request.setChannel(channel);

        if (Objects.isNull(request.getAccount())
                || Objects.isNull(request.getAmount())
                || Objects.isNull(request.getProvince())
                || Objects.isNull(request.getCity())
                || Objects.isNull(request.getOrderNo())
                || Objects.isNull(request.getApplicationName())) {
            return Message.build(false).setMessage("参数缺失");
        }


        List<String> platformListByBusinessType = PlatformEnum.getPlatformListByBusinessType(PlatformBusinessTypeEnum.ELECTRIC);
        if (!platformListByBusinessType.contains(channel)) {
            return Message.build(false).setMessage(channel + "电费充值平台暂未实现");
        }

        context.setMock(request.getMock());
        context.setSync(Boolean.FALSE);
        return Message.build();
    }

    @Override
    public void insertInfo(PlatformContext<ElectricRequest, ElectricLogEntity> context) {

        ElectricRequest request = context.getRequest();

        ElectricLogEntity electricLogEntity = new ElectricLogEntity();
        electricLogEntity.setId(sequenceCreater.nextLongId());
        electricLogEntity.setOrderNo(SequenceHolder.nextStringId());
        electricLogEntity.setOutOrderNo(request.getOrderNo());
        electricLogEntity.setProvince(request.getProvince());
        electricLogEntity.setCity(request.getCity());
        electricLogEntity.setAccount(request.getAccount());
        electricLogEntity.setCreateTime(new Date());
        electricLogEntity.setAmount(request.getAmount());
        electricLogEntity.setMock(request.getMock() ? 1 : 0);
        electricLogEntity.setPlatform(request.getChannel());
        electricLogEntity.setApplicationName(request.getApplicationName());
        electricLogEntity.setRequestId(ThreadContext.getRequestId());
        electricLogMapper.insert(electricLogEntity);

        context.setOrderInfo(electricLogEntity);
    }
}
