package com.bxm.thirdparty.platform.before.payment;

import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentModeEnum;
import com.bxm.thirdparty.platform.before.IBeforeThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.enums.PaymentOrderStatusEnum;
import com.bxm.thirdparty.platform.enums.PlatformBusinessTypeEnum;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.request.ElectricRequest;
import com.bxm.thirdparty.platform.facade.request.PaymentPreRequest;
import com.bxm.thirdparty.platform.mapper.PaymentOrderV2Mapper;
import com.bxm.thirdparty.platform.model.entity.ElectricLogEntity;
import com.bxm.thirdparty.platform.model.entity.PaymentOrderV2Entity;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/4/6 11:11
 */
@Component
public class BeforePaymentAction implements IBeforeThirdPartyPlatformAction<PaymentPreRequest, PaymentOrderV2Entity> {

    @Resource
    private PaymentOrderV2Mapper paymentOrderV2Mapper;

    @Resource
    private SequenceCreater sequenceCreater;


    @Override
    public Class<?> support() {
        return PaymentPreRequest.class;
    }

    @Override
    public Message validationArgs(PlatformContext<PaymentPreRequest, PaymentOrderV2Entity> context) {
        PaymentPreRequest request = context.getRequest();

        String payPlatform = request.getPayPlatform();
        String payMode = request.getPayMode();

        if (Objects.isNull(payPlatform)) {
            return Message.build(false).setMessage("请指定支付平台");
        }

        if (Objects.isNull(request.getAmount())
                || Objects.isNull(request.getAccountId())
                || Objects.isNull(request.getTitle())
                || Objects.isNull(request.getOrderDescription())) {
            return Message.build(false).setMessage("参数缺失");
        }

        if (Objects.equals(payPlatform, PlatformEnum.WX.name()) && Objects.equals(payMode, PaymentModeEnum.APPLET.name())) {
            if (Objects.isNull(request.getAppId()) || Objects.isNull(request.getOpenId())) {
                return Message.build(false).setMessage("小程序支付需要appId和openID");
            }
        }
        List<String> platformListByBusinessType = PlatformEnum.getPlatformListByBusinessType(PlatformBusinessTypeEnum.PAYMENT);
        if (!platformListByBusinessType.contains(payPlatform)) {
            return Message.build(false).setMessage(payPlatform + "支付平台暂未实现");
        }

        context.setMock(request.getMock());
        context.setSync(Boolean.TRUE);
        return Message.build();
    }

    @Override
    public void insertInfo(PlatformContext<PaymentPreRequest, PaymentOrderV2Entity> context) {
        PaymentPreRequest request = context.getRequest();
        PaymentOrderV2Entity paymentOrderV2Entity = new PaymentOrderV2Entity();
        paymentOrderV2Entity.setId(sequenceCreater.nextLongId());
        paymentOrderV2Entity.setApplicationName(request.getApplicationName());
        paymentOrderV2Entity.setPayPlatform(request.getPayPlatform());
        paymentOrderV2Entity.setPayMode(request.getPayMode());
        paymentOrderV2Entity.setTitle(request.getTitle());
        paymentOrderV2Entity.setDescription(request.getOrderDescription());
        paymentOrderV2Entity.setOrderNo(SequenceHolder.nextStringId());
        paymentOrderV2Entity.setOutOrderNo(request.getOrderNo());
        paymentOrderV2Entity.setAmount(request.getAmount());
        paymentOrderV2Entity.setStatus(PaymentOrderStatusEnum.WAIT.getCode());
        paymentOrderV2Entity.setMockOrder(request.getMock() ? 1 : 0);
        paymentOrderV2Entity.setRequestIp(request.getRequestIp());
        paymentOrderV2Entity.setCreateTime(new Date());
        paymentOrderV2Entity.setAppId(request.getAppId());
        paymentOrderV2Entity.setAccountId(request.getAccountId());
        paymentOrderV2Entity.setRequestId(ThreadContext.getRequestId());
        paymentOrderV2Mapper.insert(paymentOrderV2Entity);

        context.setOrderInfo(paymentOrderV2Entity);
    }
}
