package com.bxm.thirdparty.platform.before.withdraw;

import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.before.IBeforeThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.enums.PlatformBusinessTypeEnum;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.request.WithdrawRequest;
import com.bxm.thirdparty.platform.mapper.PaymentWithdrawFlowV2Mapper;
import com.bxm.thirdparty.platform.model.entity.PaymentWithdrawFlowV2Entity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/4/6 11:11
 */
@Component
@Slf4j
public class BeforeWithdrawAction implements IBeforeThirdPartyPlatformAction<WithdrawRequest, PaymentWithdrawFlowV2Entity> {

    @Resource
    private PaymentWithdrawFlowV2Mapper withdrawFlowV2Mapper;

    @Resource
    private SequenceCreater sequenceCreater;

    @Override
    public Class<?> support() {
        return WithdrawRequest.class;
    }

    @Override
    public Message validationArgs(PlatformContext context) {
        WithdrawRequest request = (WithdrawRequest) context.getRequest();
        String payPlatform = request.getPayPlatform();

        if (Objects.isNull(payPlatform)) {
            return Message.build(false).setMessage("请指定支付平台");
        }

        if (Objects.isNull(request.getAccountId())
                || Objects.isNull(request.getAmount())
                || Objects.isNull(request.getIdentity())
                || Objects.isNull(request.getApplicationName())) {
            return Message.build(false).setMessage("参数缺失");
        }

        List<String> platformListByBusinessType = PlatformEnum.getPlatformListByBusinessType(PlatformBusinessTypeEnum.PAYMENT);
        if (!platformListByBusinessType.contains(payPlatform)) {
            return Message.build(false).setMessage(payPlatform + "提现平台暂未实现");
        }

        if (Objects.equals(payPlatform, PlatformEnum.ALI.name())) {
            if (StringUtils.isBlank(request.getRealName())) {
                return Message.build(false).setMessage("支付宝提现需要指定账户真实姓名");
            }
        }

        if (Objects.equals(payPlatform, PlatformEnum.WX.name())) {
            if (StringUtils.isBlank(request.getAppId())) {
                return Message.build(false).setMessage("微信提现需要指定appId");
            }
        }
        context.setMock(request.getMock());
        context.setSync(Boolean.TRUE);
        return Message.build();
    }


    @Override
    public void insertInfo(PlatformContext<WithdrawRequest, PaymentWithdrawFlowV2Entity> context) {
        WithdrawRequest request =  context.getRequest();

        PaymentWithdrawFlowV2Entity paymentWithdrawFlowV2Entity = new PaymentWithdrawFlowV2Entity();
        paymentWithdrawFlowV2Entity.setId(sequenceCreater.nextLongId());
        paymentWithdrawFlowV2Entity.setPayPlatform(request.getPayPlatform());
        paymentWithdrawFlowV2Entity.setAccountId(request.getAccountId());
        paymentWithdrawFlowV2Entity.setIdentity(request.getIdentity());
        paymentWithdrawFlowV2Entity.setUserName(request.getRealName());
        paymentWithdrawFlowV2Entity.setAppId(request.getAppId());
        paymentWithdrawFlowV2Entity.setApplicationName(request.getApplicationName());
        paymentWithdrawFlowV2Entity.setWithdrawOrderNo(SequenceHolder.nextStringId());
        paymentWithdrawFlowV2Entity.setOutTrackNo(request.getOrderNo());
        paymentWithdrawFlowV2Entity.setStatus(0);
        paymentWithdrawFlowV2Entity.setAmount(request.getAmount());
        paymentWithdrawFlowV2Entity.setAppId(request.getAppId());
        paymentWithdrawFlowV2Entity.setCreateTime(new Date());
        paymentWithdrawFlowV2Entity.setRequestId(ThreadContext.getRequestId());
        withdrawFlowV2Mapper.insert(paymentWithdrawFlowV2Entity);

        context.setOrderInfo(paymentWithdrawFlowV2Entity);
    }
}
