package com.bxm.thirdparty.platform.callback.context;

import com.bxm.thirdparty.platform.facade.enums.NotifyTypeEnum;
import lombok.Data;

/**
 * @author lowi
 * @date 2023/4/7 16:08
 */
@Data
public class PlatformCallbackContext<T, O> {

    /**
     * 回调参数
     */
    private T callbackParam;

    /**
     * 订单信息
     */
    private O orderInfo;

    /**
     * 通知跟踪信息
     * 生成订单时候的请求id，回调时候会重置请求体id为回调原始订单信息中的requestId
     */
    private String requestId;

    private String applicationName;

    private NotifyTypeEnum notifyTypeEnum;
}
