package com.bxm.thirdparty.platform.callback.param;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author lowi
 * @date 2022/6/21 10:44
 */
@Data
public class XinRongChargePhoneParam {
    /**
     * 商户在系统中开设的唯一编号
     */
    private String client_id;

    /**
     * 商户交易订单号,咱们服务传递的订单号
     */
    private String out_logno;

    /**
     * 平台流水号，第三方平台生成的订单号
     */
    private String logno;

    /**
     * 充值金额，单位：元 两位小数
     */
    private BigDecimal money;

    /**
     * 格式：时间戳
     */
    private Long paytime;

    /**
     * 0：处理中
     * 1：成功
     * 2：失败
     */
    private Integer status;

    /**
     * 官方订单流水号，失败则为空
     */
    private String ordersn;

    /**
     * 订单描述
     */
    private String msg;

}
