package com.bxm.thirdparty.platform.callback.payment.ali;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.callback.IPlatformCallbackAction;
import com.bxm.thirdparty.platform.callback.context.PlatformCallbackContext;
import com.bxm.thirdparty.platform.callback.param.AlipayPaymentCallbackParam;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PaymentOrderStatusEnum;
import com.bxm.thirdparty.platform.facade.notify.PaymentNotifyResponse;
import com.bxm.thirdparty.platform.mapper.PaymentOrderV2Mapper;
import com.bxm.thirdparty.platform.model.entity.PaymentOrderV2Entity;
import com.bxm.thirdparty.platform.model.enums.LegerTypeEnum;
import com.bxm.thirdparty.platform.model.param.LegerLogParam;
import com.bxm.thirdparty.platform.service.LedgerLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/4/4 16:57
 */
@Component
@Slf4j
public class AliPaymentCallbackAction implements IPlatformCallbackAction<AlipayPaymentCallbackParam, PaymentOrderV2Entity> {

    @Resource
    private PaymentOrderV2Mapper paymentOrderV2Mapper;

    @Resource
    private LedgerLogService ledgerLogService;

    @Override
    public Class<?> support() {
        return AlipayPaymentCallbackParam.class;
    }

    @Override
    public Message execCallback(PlatformCallbackContext<AlipayPaymentCallbackParam, PaymentOrderV2Entity> context) {
        AlipayPaymentCallbackParam param = context.getCallbackParam();
        PaymentOrderV2Entity paymentOrderV2Entity = context.getOrderInfo();
        //订单不是待支付或者超时的话，说明回调重复了
        if (!Objects.equals(paymentOrderV2Entity.getStatus(), PaymentOrderStatusEnum.WAIT.getCode())
                && !Objects.equals(paymentOrderV2Entity.getStatus(), PaymentOrderStatusEnum.TIMEOUT.getCode())
        ) {
            log.warn("订单状态【{}】不对，已被处理,callback:{}", paymentOrderV2Entity.getStatus(), param);
            return Message.build(false).setMessage("回调信息已处理");
        }

        int status;
        boolean success;
        if (CommonConstant.ALIPAY_TRADE_SUCCESS.equals(param.getTradeStatus())) {
            status = PaymentOrderStatusEnum.SUCCESS.getCode();
            success = Boolean.TRUE;
            //增加账本数据
            ledgerLogService.insertLedgerLog(LegerLogParam.builder()
                    .legerTypeEnum(LegerTypeEnum.PAY)
                    .payPlatform(paymentOrderV2Entity.getPayPlatform())
                    .accountId(paymentOrderV2Entity.getAccountId())
                    .amount(paymentOrderV2Entity.getAmount())
                    .build());
        } else {
            status = PaymentOrderStatusEnum.FAIL.getCode();
            success = Boolean.FALSE;
        }

        PaymentOrderV2Entity updateClass = new PaymentOrderV2Entity();
        updateClass.setId(paymentOrderV2Entity.getId());
        updateClass.setStatus(status);
        updateClass.setThirdPartyTradeNo(param.getTradeNo());
        paymentOrderV2Mapper.updateById(updateClass);

        PaymentNotifyResponse response = new PaymentNotifyResponse();
        response.setSuccess(success);
        response.setOrderNo(paymentOrderV2Entity.getOrderNo().toString());
        response.setOutOrderNo(paymentOrderV2Entity.getOutOrderNo());
        return Message.build().addParam(CommonConstant.RESULT_DTO, response);
    }
}
