package com.bxm.thirdparty.platform.callback.xinrong;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.chargephone.xinrong.enums.XinRongStatusEnum;
import com.bxm.thirdparty.platform.adapter.chargephone.xinrong.utils.XinRongUtil;
import com.bxm.thirdparty.platform.callback.IPlatformCallbackAction;
import com.bxm.thirdparty.platform.callback.context.PlatformCallbackContext;
import com.bxm.thirdparty.platform.callback.param.LiBaCallbackParam;
import com.bxm.thirdparty.platform.callback.param.XinRongChargePhoneParam;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.facade.notify.ChargePhoneNotifyResponse;
import com.bxm.thirdparty.platform.mapper.ChargesPhoneLogMapper;
import com.bxm.thirdparty.platform.model.entity.ChargesPhoneLogEntity;
import lombok.extern.slf4j.Slf4j;
import org.checkerframework.checker.units.qual.C;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/4/4 16:57
 */
@Component
@Slf4j
public class XinRongCallbackAction implements IPlatformCallbackAction {

    @Resource
    private ChargesPhoneLogMapper chargesPhoneLogMapper;

    @Resource
    private ThirdPartyConfigProperties thirdPartyConfigProperties;

    @Override
    public Class<?> support() {
        return XinRongChargePhoneParam.class;
    }

    @Override
    public Message execCallback(PlatformCallbackContext context) {
        XinRongChargePhoneParam xinRongChargePhoneParam = (XinRongChargePhoneParam) context.getCallbackParam();
        ChargesPhoneLogEntity chargesPhoneLogEntity = (ChargesPhoneLogEntity) context.getOrderInfo();

        if (!Objects.equals(chargesPhoneLogEntity.getStatus(), XinRongStatusEnum.WAITING.getStatus())) {
            log.error("心融回调信息已处理：{}", context);
            return Message.build(false);
        }
        XinRongUtil xinRongUtil = new   XinRongUtil(thirdPartyConfigProperties);

        BigDecimal sellMoney = xinRongUtil.getSellMoney(xinRongChargePhoneParam.getOut_logno(), xinRongChargePhoneParam.getLogno());
        //更新订单信息
        ChargesPhoneLogEntity updateClass = new ChargesPhoneLogEntity();
        updateClass.setThirdPartyTrackNo(xinRongChargePhoneParam.getLogno());
        updateClass.setStatus(xinRongChargePhoneParam.getStatus());
        updateClass.setId(chargesPhoneLogEntity.getId());
        updateClass.setModifyTime(new Date());
        updateClass.setErrorMsg(xinRongChargePhoneParam.getMsg());
        updateClass.setSellMoney(sellMoney);
        chargesPhoneLogMapper.updateById(updateClass);

        //填充通知返回体
        ChargePhoneNotifyResponse response = new ChargePhoneNotifyResponse();
        if (Objects.equals(xinRongChargePhoneParam.getStatus(), XinRongStatusEnum.SUCCESS.getStatus())) {
            response.setSuccess(true);
            response.setSellMoney(sellMoney);
        } else {
            response.setSuccess(false);
            response.setErrorMsg(xinRongChargePhoneParam.getMsg());
        }
        response.setOrderNo(chargesPhoneLogEntity.getOrderNo().toString());
        response.setOutOrderNo(chargesPhoneLogEntity.getOutOrderNo());

        return Message.build().addParam(CommonConstant.RESULT_DTO, response);
    }
}
