package com.bxm.thirdparty.platform.context;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lowi
 * @date 2023/4/8 16:01
 */
public class ThreadContext {

    private final static ThreadLocal<Map<String, String>> CTX_HOLDER = new ThreadLocal<>();

    static {
        CTX_HOLDER.set(new HashMap<>());
    }

    /**
     * traceID
     */
    public final static String REQUEST_ID_KEY = "requestIdKey";

    /**
     * 客户端IP
     */
    public static final String CLIENT_IP_KEY = "clientIp";

    /**
     * 初始化线程上下文
     */
    public final static void init() {
        CTX_HOLDER.set(new HashMap<>());
    }
    /**
     * 设置IP
     *
     * @param ip
     */
    public static final void putClientIp(String ip) {
        putContext(CLIENT_IP_KEY, ip);
    }

    /**
     * 设置traceID数据
     */
    public final static void putRequestId(String traceId) {
        putContext(REQUEST_ID_KEY, traceId);
    }

    /**
     * 清空线程上下文
     */
    public final static void clean() {
        CTX_HOLDER.remove();
    }

    /**
     * 添加内容到线程上下文中
     *
     * @param key
     * @param value
     */
    public final static void putContext(String key, String value) {
        Map<String, String> ctx = CTX_HOLDER.get();
        if (ctx == null) {
            return;
        }
        ctx.put(key, value);
    }

    /**
     * 获取traceID数据
     */
    public final static String getRequestId() {
        return getContext(REQUEST_ID_KEY);
    }

    /**
     * 获取traceID数据
     */
    public final static String getClientIp() {
        return getContext(CLIENT_IP_KEY);
    }
    /**
     * 从线程上下文中获取内容
     *
     * @param key
     */
    public final static String getContext(String key) {
        Map<String, String> ctx = CTX_HOLDER.get();
        if (ctx == null) {
            return null;
        }
        return ctx.get(key);
    }



}
