package com.bxm.thirdparty.platform.queue.notifybusiness.defaults;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.thirdparty.platform.context.FailInfoContext;
import com.bxm.thirdparty.platform.queue.QueueService;
import com.bxm.thirdparty.platform.queue.bo.QueueBO;
import com.bxm.thirdparty.platform.queue.bo.RequestBodyBO;
import com.bxm.thirdparty.platform.queue.notifybusiness.INotifyBusinessAction;
import com.bxm.thirdparty.platform.queue.notifybusiness.enums.QueueEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * @author lowi
 * @date 2023/3/28 20:07
 */
@Component
@Slf4j
public class IDefaultAction implements INotifyBusinessAction {

    private QueueService getQueueService() {
        return SpringContextHolder.getBean(QueueService.class);
    }

    @Override
    public String type() {
        return QueueEnum.DEFAULT.name();
    }

    @Override
    public void notifyBusiness(QueueBO queueBO) {

        HttpRequest httpRequest = HttpUtil.createPost(queueBO.getNotifyUrl());
        RequestBodyBO requestBodyBO = queueBO.getRequestBodyBO();
        httpRequest.body(JSON.toJSONString(requestBodyBO));
        httpRequest.contentType("application/json");
        HttpResponse execute = null;
        String errorMsg;
        try {
            execute = httpRequest.execute();
            if (execute.isOk() && Objects.equals(execute.body(), "SUCCESS")) {
                //只要调通，返回success，则成功
                log.info("回调业务方成功：{}", queueBO);
                getQueueService().updateNotifyInfoSuccess(queueBO.getRequestId());
                return;
            } else {
                errorMsg = "回调业务方失败，未返回预期的值" + execute.getStatus();
                log.warn("回调业务方失败：{}", queueBO);
            }
        } catch (Exception e) {
            //丢入失败队列
            log.error("回调业务方服务500：{}", queueBO, e);
            errorMsg = "回调业务方服务失败" + e.getMessage();
        }

        FailInfoContext failInfoContext = new FailInfoContext();
        failInfoContext.setErrorMsg(errorMsg);
        failInfoContext.setRequestId(queueBO.getRequestId());
        failInfoContext.setRequest(JSON.toJSONString(queueBO));
        getQueueService().addBusinessFailInfo(queueBO, errorMsg);

    }
}