package com.bxm.thirdparty.platform.service.impl;

import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.bxm.thirdparty.platform.mapper.LedgerLogMapper;
import com.bxm.thirdparty.platform.model.entity.LedgerLogEntity;
import com.bxm.thirdparty.platform.model.param.LegerLogParam;
import com.bxm.thirdparty.platform.service.LedgerLogService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * @author lowi
 * @date 2023/4/17 17:41
 */
@Slf4j
@Service
@AllArgsConstructor
public class LedgerLogServiceImpl implements LedgerLogService {

    private final LedgerLogMapper ledgerLogMapper;

    @Override
    public void insertLedgerLog(LegerLogParam legerLogParam) {
        LedgerLogEntity ledgerLogEntity = new LedgerLogEntity();
        ledgerLogEntity.setId(SequenceHolder.nextLongId());
        ledgerLogEntity.setAccountId(legerLogParam.getAccountId());
        ledgerLogEntity.setPlatform(legerLogParam.getPayPlatform());
        ledgerLogEntity.setAmount(legerLogParam.getAmount());
        ledgerLogEntity.setType(legerLogParam.getLegerTypeEnum().name());
        ledgerLogEntity.setTypeMsg(legerLogParam.getLegerTypeEnum().getDesc());
        ledgerLogEntity.setCreateTime(LocalDateTime.now());
        ledgerLogMapper.insert(ledgerLogEntity);
    }
}
