package com.bxm.thirdparty.platform.service.impl;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.callback.PlatformCallbackManage;
import com.bxm.thirdparty.platform.callback.context.PlatformCallbackContext;
import com.bxm.thirdparty.platform.callback.param.*;
import com.bxm.thirdparty.platform.facade.enums.NotifyTypeEnum;
import com.bxm.thirdparty.platform.mapper.ChargesPhoneLogMapper;
import com.bxm.thirdparty.platform.mapper.ElectricLogMapper;
import com.bxm.thirdparty.platform.mapper.PaymentOrderV2Mapper;
import com.bxm.thirdparty.platform.mapper.PaymentRefundV2Mapper;
import com.bxm.thirdparty.platform.model.entity.ChargesPhoneLogEntity;
import com.bxm.thirdparty.platform.model.entity.ElectricLogEntity;
import com.bxm.thirdparty.platform.model.entity.PaymentOrderV2Entity;
import com.bxm.thirdparty.platform.model.entity.PaymentRefundV2Entity;
import com.bxm.thirdparty.platform.service.ThirdPartyCallbackService;
import com.bxm.thirdparty.platform.utils.TraceUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author lowi
 * @date 2023/4/7 17:17
 */
@Slf4j
@Service
@AllArgsConstructor
public class ThirdPartyCallbackServiceImpl implements ThirdPartyCallbackService {

    private final PlatformCallbackManage platformCallbackManage;

    private final PaymentOrderV2Mapper paymentOrderV2Mapper;

    private final PaymentRefundV2Mapper paymentRefundV2Mapper;

    private final ElectricLogMapper electricLogMapper;

    private final ChargesPhoneLogMapper chargesPhoneLogMapper;

    @Override
    public Message execAlipayTradeCallback(AlipayPaymentCallbackParam param) {
        PaymentOrderV2Entity paymentOrderV2Entity = paymentOrderV2Mapper.getByOrderNo(param.getOutTradeNo());
        if (Objects.isNull(paymentOrderV2Entity)) {
            return Message.build(false).setMessage("支付订单信息不存在");
        }
        TraceUtil.replaceRequestId(paymentOrderV2Entity.getRequestId());
        log.info("重置requestId，支付宝回调参数: {},", param);
        PlatformCallbackContext<AlipayPaymentCallbackParam, PaymentOrderV2Entity> context = new PlatformCallbackContext<>();
        context.setCallbackParam(param);
        context.setOrderInfo(paymentOrderV2Entity);
        context.setNotifyTypeEnum(NotifyTypeEnum.PAYMENT);
        context.setApplicationName(paymentOrderV2Entity.getApplicationName());
        context.setRequestId(paymentOrderV2Entity.getRequestId());
        return platformCallbackManage.execCallback(context);
    }

    @Override
    public Message executeWechatCallback(WxPaymentCallbackParam param) {
        PaymentOrderV2Entity paymentOrderV2Entity = paymentOrderV2Mapper.getByOrderNo(param.getPaymentOrderNo());
        if (Objects.isNull(paymentOrderV2Entity)) {
            return Message.build(false).setMessage("支付订单信息不存在");
        }
        TraceUtil.replaceRequestId(paymentOrderV2Entity.getRequestId());
        log.info("重置requestId，微信回调参数: {},", param);
        PlatformCallbackContext<WxPaymentCallbackParam, PaymentOrderV2Entity> context = new PlatformCallbackContext<>();
        context.setCallbackParam(param);
        context.setOrderInfo(paymentOrderV2Entity);
        context.setNotifyTypeEnum(NotifyTypeEnum.PAYMENT);
        context.setApplicationName(paymentOrderV2Entity.getApplicationName());
        context.setRequestId(paymentOrderV2Entity.getRequestId());
        return platformCallbackManage.execCallback(context);
    }

    @Override
    public Message execXinrongCallback(XinRongChargePhoneParam param) {
        ChargesPhoneLogEntity chargesPhoneLogEntity = chargesPhoneLogMapper.getByOrderNo(param.getOut_logno());
        if (Objects.isNull(chargesPhoneLogEntity)) {
            return Message.build(false).setMessage("话费订单信息不存在");
        }
        TraceUtil.replaceRequestId(chargesPhoneLogEntity.getRequestId());
        log.info("重置requestId，心融回调参数: {},", param);
        PlatformCallbackContext<XinRongChargePhoneParam, ChargesPhoneLogEntity> context = new PlatformCallbackContext<>();
        context.setCallbackParam(param);
        context.setOrderInfo(chargesPhoneLogEntity);
        context.setNotifyTypeEnum(NotifyTypeEnum.CHARGE_PHONE);
        context.setApplicationName(chargesPhoneLogEntity.getApplicationName());
        context.setRequestId(chargesPhoneLogEntity.getRequestId());
        return platformCallbackManage.execCallback(context);
    }

    @Override
    public Message execLiBaCallback(LiBaCallbackParam param) {
        ElectricLogEntity electricLogEntity = electricLogMapper.getByOrderNo(param.getOrderId());
        if (Objects.isNull(electricLogEntity)) {
            return Message.build(false).setMessage("电费订单信息不存在");
        }
        TraceUtil.replaceRequestId(electricLogEntity.getRequestId());
        log.info("重置requestId，力拔回调参数: {},", param);
        PlatformCallbackContext<LiBaCallbackParam, ElectricLogEntity> context = new PlatformCallbackContext<>();
        context.setCallbackParam(param);
        context.setOrderInfo(electricLogEntity);
        context.setNotifyTypeEnum(NotifyTypeEnum.ELECTRIC);
        context.setApplicationName(electricLogEntity.getApplicationName());
        context.setRequestId(electricLogEntity.getRequestId());
        return platformCallbackManage.execCallback(context);
    }

    @Override
    public Message execWechatRefund(WxRefundCallbackParam param) {
        PaymentRefundV2Entity orderInfo = paymentRefundV2Mapper.getByRefundOrderNo(param.getRefundOrderNo());
        if (Objects.isNull(orderInfo)) {
            return Message.build(false).setMessage("退款订单信息不存在");
        }
        TraceUtil.replaceRequestId(orderInfo.getRequestId());
        log.info("重置requestId，微信退款回调参数: {},", param);
        PlatformCallbackContext<WxRefundCallbackParam, PaymentRefundV2Entity> context = new PlatformCallbackContext<>();
        context.setCallbackParam(param);
        context.setOrderInfo(orderInfo);
        context.setNotifyTypeEnum(NotifyTypeEnum.REFUND);
        context.setApplicationName(orderInfo.getApplicationName());
        context.setRequestId(orderInfo.getRequestId());
        return platformCallbackManage.execCallback(context);
    }
}
